/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax.parser;

import java.util.List;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.ql.AggregationFunction;
import org.infinispan.objectfilter.impl.ql.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.parser.TypeDescriptor;
import org.jboss.logging.Logger;

public final class AggregationPropertyPath<TypeMetadata>
extends PropertyPath<TypeDescriptor<TypeMetadata>> {
    private static final Log log = Logger.getMessageLogger(Log.class, AggregationPropertyPath.class.getName());
    private final AggregationFunction aggregationFunction;

    AggregationPropertyPath(AggregationFunction aggregationFunction, List<PropertyPath.PropertyReference<TypeDescriptor<TypeMetadata>>> path) {
        super(path);
        switch (aggregationFunction) {
            case SUM: 
            case AVG: 
            case MIN: 
            case MAX: 
            case COUNT: {
                break;
            }
            default: {
                throw log.getAggregationTypeNotSupportedException(aggregationFunction.name());
            }
        }
        this.aggregationFunction = aggregationFunction;
    }

    public AggregationFunction getAggregationFunction() {
        return this.aggregationFunction;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        AggregationPropertyPath that = (AggregationPropertyPath)o;
        return this.aggregationFunction == that.aggregationFunction;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.aggregationFunction.hashCode();
    }

    @Override
    public String toString() {
        return this.aggregationFunction.name() + "(" + this.asStringPath() + ")";
    }
}

