/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.Matcher;
import org.infinispan.objectfilter.ObjectFilter;
import org.infinispan.objectfilter.impl.AcceptObjectFilter;
import org.infinispan.objectfilter.impl.FilterRegistry;
import org.infinispan.objectfilter.impl.FilterSubscriptionImpl;
import org.infinispan.objectfilter.impl.MetadataAdapter;
import org.infinispan.objectfilter.impl.ObjectFilterImpl;
import org.infinispan.objectfilter.impl.RejectObjectFilter;
import org.infinispan.objectfilter.impl.aggregation.FieldAccumulator;
import org.infinispan.objectfilter.impl.logging.Log;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.syntax.ConstantBooleanExpr;
import org.infinispan.objectfilter.impl.syntax.FullTextVisitor;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParser;
import org.infinispan.objectfilter.impl.syntax.parser.IckleParsingResult;
import org.infinispan.objectfilter.impl.syntax.parser.ObjectPropertyHelper;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.impl.BaseQuery;
import org.jboss.logging.Logger;

public abstract class BaseMatcher<TypeMetadata, AttributeMetadata, AttributeId extends Comparable<AttributeId>>
implements Matcher {
    private static final Log log = Logger.getMessageLogger(Log.class, BaseMatcher.class.getName());
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock read = this.readWriteLock.readLock();
    private final Lock write = this.readWriteLock.writeLock();
    private final Map<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> filtersByType = new HashMap<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>>();
    private final Map<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> deltaFiltersByType = new HashMap<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>>();
    protected final ObjectPropertyHelper<TypeMetadata> propertyHelper;

    protected BaseMatcher(ObjectPropertyHelper<TypeMetadata> propertyHelper) {
        this.propertyHelper = propertyHelper;
    }

    public ObjectPropertyHelper<TypeMetadata> getPropertyHelper() {
        return this.propertyHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void match(Object userContext, Object eventType, Object instance) {
        if (instance == null) {
            throw new IllegalArgumentException("instance cannot be null");
        }
        this.read.lock();
        try {
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx = this.startMultiTypeContext(false, userContext, eventType, instance);
            if (ctx != null) {
                ctx.process(ctx.getRootNode());
                ctx.notifySubscribers();
            }
        }
        finally {
            this.read.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void matchDelta(Object userContext, Object eventType, Object instanceOld, Object instanceNew, Object joiningEvent, Object updatedEvent, Object leavingEvent) {
        if (instanceOld == null && instanceNew == null) {
            throw new IllegalArgumentException("instances cannot be both null");
        }
        this.read.lock();
        try {
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx1 = null;
            MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> ctx2 = null;
            if (instanceOld != null && (ctx1 = this.startMultiTypeContext(true, userContext, eventType, instanceOld)) != null) {
                ctx1.process(ctx1.getRootNode());
            }
            if (instanceNew != null && (ctx2 = this.startMultiTypeContext(true, userContext, eventType, instanceNew)) != null) {
                ctx2.process(ctx2.getRootNode());
            }
            if (ctx1 != null) {
                ctx1.notifyDeltaSubscribers(ctx2, joiningEvent, updatedEvent, leavingEvent);
            } else if (ctx2 != null) {
                ctx2.notifyDeltaSubscribers(null, leavingEvent, updatedEvent, joiningEvent);
            }
        }
        finally {
            this.read.unlock();
        }
    }

    @Override
    public ObjectFilter getObjectFilter(Query query) {
        return this.getObjectFilter(((BaseQuery)query).getQueryString(), null);
    }

    @Override
    public ObjectFilter getObjectFilter(String queryString) {
        return this.getObjectFilter(queryString, null);
    }

    @Override
    public ObjectFilter getObjectFilter(String queryString, List<FieldAccumulator> acc) {
        IckleParsingResult<TypeMetadata> parsingResult = IckleParser.parse(queryString, this.propertyHelper);
        this.disallowGroupingAndAggregations(parsingResult);
        if (parsingResult.getWhereClause() == ConstantBooleanExpr.FALSE) {
            return new RejectObjectFilter<TypeMetadata>(null, parsingResult);
        }
        MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> metadataAdapter = this.createMetadataAdapter(parsingResult.getTargetEntityMetadata());
        if ((parsingResult.getWhereClause() == null || parsingResult.getWhereClause() == ConstantBooleanExpr.TRUE) && parsingResult.getSortFields() == null && parsingResult.getProjectedPaths() == null) {
            return new AcceptObjectFilter<TypeMetadata, AttributeMetadata, AttributeId>(null, this, metadataAdapter, parsingResult);
        }
        FieldAccumulator[] accumulators = acc != null ? acc.toArray(new FieldAccumulator[acc.size()]) : null;
        return new ObjectFilterImpl<TypeMetadata, AttributeMetadata, AttributeId>(this, metadataAdapter, parsingResult, accumulators);
    }

    @Override
    public ObjectFilter getObjectFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        ObjectFilter objectFilter = this.getObjectFilter(filterSubscriptionImpl.getQueryString());
        return filterSubscriptionImpl.getNamedParameters() != null ? objectFilter.withParameters(filterSubscriptionImpl.getNamedParameters()) : objectFilter;
    }

    @Override
    public FilterSubscription registerFilter(Query query, FilterCallback callback, Object ... eventType) {
        return this.registerFilter(query, callback, false, eventType);
    }

    @Override
    public FilterSubscription registerFilter(Query query, FilterCallback callback, boolean isDeltaFilter, Object ... eventType) {
        BaseQuery baseQuery = (BaseQuery)query;
        return this.registerFilter(baseQuery.getQueryString(), baseQuery.getParameters(), callback, isDeltaFilter, eventType);
    }

    @Override
    public FilterSubscription registerFilter(String queryString, FilterCallback callback, Object ... eventType) {
        return this.registerFilter(queryString, callback, false, eventType);
    }

    @Override
    public FilterSubscription registerFilter(String queryString, FilterCallback callback, boolean isDeltaFilter, Object ... eventType) {
        return this.registerFilter(queryString, (Map<String, Object>)null, callback, isDeltaFilter, eventType);
    }

    @Override
    public FilterSubscription registerFilter(String queryString, Map<String, Object> namedParameters, FilterCallback callback, Object ... eventType) {
        return this.registerFilter(queryString, namedParameters, callback, false, eventType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FilterSubscription registerFilter(String queryString, Map<String, Object> namedParameters, FilterCallback callback, boolean isDeltaFilter, Object ... eventType) {
        IckleParsingResult<TypeMetadata> parsingResult = IckleParser.parse(queryString, this.propertyHelper);
        this.disallowGroupingAndAggregations(parsingResult);
        this.disallowFullText(parsingResult);
        Map<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> filterMap = isDeltaFilter ? this.deltaFiltersByType : this.filtersByType;
        this.write.lock();
        try {
            FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = filterMap.get(parsingResult.getTargetEntityMetadata());
            if (filterRegistry == null) {
                filterRegistry = new FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>(this.createMetadataAdapter(parsingResult.getTargetEntityMetadata()), true);
                filterMap.put(filterRegistry.getMetadataAdapter().getTypeMetadata(), filterRegistry);
            }
            FilterSubscriptionImpl<TypeMetadata, AttributeMetadata, AttributeId> filterSubscriptionImpl = filterRegistry.addFilter(queryString, namedParameters, parsingResult.getWhereClause(), parsingResult.getProjections(), parsingResult.getProjectedTypes(), parsingResult.getSortFields(), callback, isDeltaFilter, eventType);
            return filterSubscriptionImpl;
        }
        finally {
            this.write.unlock();
        }
    }

    private void disallowFullText(IckleParsingResult<TypeMetadata> parsingResult) {
        if (parsingResult.getWhereClause() != null && ((Boolean)parsingResult.getWhereClause().acceptVisitor(FullTextVisitor.INSTANCE)).booleanValue()) {
            throw log.getFiltersCannotUseFullTextSearchException();
        }
    }

    private void disallowGroupingAndAggregations(IckleParsingResult<TypeMetadata> parsingResult) {
        if (parsingResult.hasGroupingOrAggregations()) {
            throw log.getFiltersCannotUseGroupingOrAggregationException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterFilter(FilterSubscription filterSubscription) {
        FilterSubscriptionImpl filterSubscriptionImpl = (FilterSubscriptionImpl)filterSubscription;
        Map<TypeMetadata, FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId>> filterMap = filterSubscription.isDeltaFilter() ? this.deltaFiltersByType : this.filtersByType;
        this.write.lock();
        try {
            FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> filterRegistry = filterMap.get(filterSubscriptionImpl.getMetadataAdapter().getTypeMetadata());
            if (filterRegistry == null) {
                throw new IllegalStateException("No filter was found for type " + filterSubscriptionImpl.getMetadataAdapter().getTypeMetadata());
            }
            filterRegistry.removeFilter(filterSubscription);
            if (filterRegistry.getFilterSubscriptions().isEmpty()) {
                filterMap.remove(filterRegistry.getMetadataAdapter().getTypeMetadata());
            }
        }
        finally {
            this.write.unlock();
        }
    }

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> startMultiTypeContext(boolean var1, Object var2, Object var3, Object var4);

    protected abstract MatcherEvalContext<TypeMetadata, AttributeMetadata, AttributeId> startSingleTypeContext(Object var1, Object var2, Object var3, MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> var4);

    protected abstract MetadataAdapter<TypeMetadata, AttributeMetadata, AttributeId> createMetadataAdapter(TypeMetadata var1);

    protected final FilterRegistry<TypeMetadata, AttributeMetadata, AttributeId> getFilterRegistryForType(boolean isDeltaFilter, TypeMetadata entityType) {
        return isDeltaFilter ? this.deltaFiltersByType.get(entityType) : this.filtersByType.get(entityType);
    }

    protected Object convert(Object instance) {
        return instance;
    }
}

