/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.store.Lock;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.InvalidLockException;
import org.infinispan.lucene.impl.ObtainableLock;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.LocalModeAddress;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class BaseLuceneLock
extends Lock
implements Closeable,
ObtainableLock {
    private static final Log log = LogFactory.getLog(BaseLuceneLock.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Cache<Object, Object> noCacheStoreCache;
    private final String lockName;
    private final String indexName;
    private final FileCacheKey keyOfLock;
    private final Address valueOfLock;

    BaseLuceneLock(Cache<?, ?> cache, String indexName, String lockName, int affinitySegmentId) {
        this.noCacheStoreCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD});
        this.lockName = lockName;
        this.indexName = indexName;
        this.keyOfLock = new FileCacheKey(indexName, lockName, affinitySegmentId);
        Address address = this.noCacheStoreCache.getCacheManager().getAddress();
        this.valueOfLock = address == null ? LocalModeAddress.INSTANCE : address;
    }

    @Override
    public boolean obtain() {
        Object previousValue = this.noCacheStoreCache.putIfAbsent((Object)this.keyOfLock, (Object)this.valueOfLock);
        if (trace) {
            log.tracef("Result of lock acquiring %s", previousValue);
        }
        if (previousValue == null) {
            if (trace) {
                log.tracef("Lock: %s acquired for index: %s from %s", (Object)this.lockName, (Object)this.indexName, (Object)this.valueOfLock);
            }
            return true;
        }
        if (trace) {
            log.tracef("Lock: %s not acquired for index: %s from %s, was taken already by %s.", new Object[]{this.lockName, this.indexName, this.valueOfLock, previousValue});
        }
        return false;
    }

    public void clearLock() {
        Object lockOwner = this.noCacheStoreCache.get((Object)this.keyOfLock);
        if (lockOwner == null || this.valueOfLock.equals(lockOwner)) {
            Object previousValue = this.noCacheStoreCache.remove((Object)this.keyOfLock);
            log.tracef("Lock: %s removed for index: %s from %s (was %s)", new Object[]{this.lockName, this.indexName, this.valueOfLock, previousValue});
        } else {
            log.tracef("Lock: %s not cleared for index: %s from %s, was taken already by %s.", new Object[]{this.lockName, this.indexName, this.valueOfLock, lockOwner});
        }
    }

    public boolean isLocked() {
        return this.noCacheStoreCache.containsKey((Object)this.keyOfLock);
    }

    @Override
    public void close() {
        this.clearLock();
    }

    @Override
    public void ensureValid() throws IOException {
        if (!this.isLocked()) {
            throw new InvalidLockException("This lock is no longer being held");
        }
    }
}

