/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.regex.Pattern;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.logging.Log;
import org.infinispan.persistence.keymappers.TwoWayKey2StringMapper;
import org.infinispan.util.logging.LogFactory;

public final class LuceneKey2StringMapper
implements TwoWayKey2StringMapper {
    static final Pattern singlePipePattern = Pattern.compile("\\|");
    private static final Log log = (Log)LogFactory.getLog(LuceneKey2StringMapper.class, Log.class);

    public boolean isSupportedType(Class<?> keyType) {
        return keyType == ChunkCacheKey.class || keyType == FileCacheKey.class || keyType == FileListCacheKey.class || keyType == FileReadLockKey.class;
    }

    public String getStringMapping(Object key) {
        return key.toString();
    }

    public Object getKeyMapping(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Not supporting null keys");
        }
        String[] split = singlePipePattern.split(key);
        switch (split[0]) {
            case "C": {
                if (split.length != 6) {
                    throw log.keyMappperUnexpectedStringFormat(key);
                }
                String indexName = split[4];
                String fileName = split[1];
                int chunkId = this.toInt(split[2], key);
                int bufferSize = this.toInt(split[3], key);
                int affinitySegmentId = this.toInt(split[5], key);
                return new ChunkCacheKey(indexName, fileName, chunkId, bufferSize, affinitySegmentId);
            }
            case "M": {
                if (split.length != 4) {
                    throw log.keyMappperUnexpectedStringFormat(key);
                }
                String indexName = split[2];
                String fileName = split[1];
                int affinitySegmentId = this.toInt(split[3], key);
                return new FileCacheKey(indexName, fileName, affinitySegmentId);
            }
            case "*": {
                if (split.length != 3) {
                    throw log.keyMappperUnexpectedStringFormat(key);
                }
                String indexName = split[1];
                int affinitySegmentId = this.toInt(split[2], key);
                return new FileListCacheKey(indexName, affinitySegmentId);
            }
            case "RL": {
                if (split.length != 4) {
                    throw log.keyMappperUnexpectedStringFormat(key);
                }
                String indexName = split[2];
                String fileName = split[1];
                int affinitySegmentId = this.toInt(split[3], key);
                return new FileReadLockKey(indexName, fileName, affinitySegmentId);
            }
        }
        throw log.keyMappperUnexpectedStringFormat(key);
    }

    private int toInt(String token, String fullInput) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException nfe) {
            throw log.keyMappperUnexpectedStringFormat(fullInput);
        }
    }
}

