/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.DirectoryProviderHelper;
import org.hibernate.search.store.spi.DirectoryHelper;
import org.hibernate.search.util.impl.FileHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FSMasterDirectoryProvider
implements DirectoryProvider<FSDirectory> {
    private static final String CURRENT1 = "current1";
    private static final String CURRENT2 = "current2";
    private static final String[] CURRENT_DIR_NAME = new String[]{null, "current1", "current2"};
    private static final Log log = LoggerFactory.make();
    private final Timer timer = new Timer(true);
    private volatile int current;
    private FSDirectory directory;
    private Path sourceDir;
    private Path indexDir;
    private String directoryProviderName;
    private Properties properties;
    private TriggerTask task;
    private Lock directoryProviderLock;

    @Override
    public void initialize(String directoryProviderName, Properties properties, BuildContext context) {
        this.properties = properties;
        this.directoryProviderName = directoryProviderName;
        this.sourceDir = DirectoryProviderHelper.getSourceDirectoryPath(directoryProviderName, properties, true);
        log.debugf("Source directory: %s", (Object)this.sourceDir);
        this.indexDir = DirectoryHelper.getVerifiedIndexPath(directoryProviderName, properties, true).normalize();
        log.debugf("Index directory: %s", (Object)this.indexDir);
        try {
            this.directory = DirectoryProviderHelper.createFSIndex(this.indexDir, properties, context.getServiceManager());
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + directoryProviderName, e);
        }
        DirectoryProviderHelper.getCopyBufferSize(directoryProviderName, properties);
        this.current = 0;
    }

    @Override
    public void start(DirectoryBasedIndexManager indexManager) {
        int currentLocal = 0;
        this.directoryProviderLock = indexManager.getDirectoryModificationLock();
        try {
            if (Files.exists(this.sourceDir.resolve(CURRENT1), new LinkOption[0])) {
                currentLocal = 2;
            } else if (Files.exists(this.sourceDir.resolve(CURRENT2), new LinkOption[0])) {
                currentLocal = 1;
            } else {
                log.debugf("Source directory for '%s' will be initialized", (Object)this.indexDir.toString());
                currentLocal = 1;
            }
            String currentString = Integer.valueOf(currentLocal).toString();
            Path subDir = this.sourceDir.resolve(currentString);
            FileHelper.synchronize(this.indexDir, subDir, true);
            Files.deleteIfExists(this.sourceDir.resolve(CURRENT1));
            Files.deleteIfExists(this.sourceDir.resolve(CURRENT2));
            Files.createFile(this.sourceDir.resolve(CURRENT_DIR_NAME[currentLocal]), new FileAttribute[0]);
            log.debugf("Current directory: %d", (Object)currentLocal);
        }
        catch (IOException e) {
            throw new SearchException("Unable to initialize index: " + this.directoryProviderName, e);
        }
        this.task = new TriggerTask(this.indexDir, this.sourceDir);
        long period = DirectoryProviderHelper.getRefreshPeriod(this.properties, this.directoryProviderName);
        this.timer.scheduleAtFixedRate((TimerTask)this.task, period, period);
        this.current = currentLocal;
    }

    @Override
    public FSDirectory getDirectory() {
        int readCurrentState = this.current;
        return this.directory;
    }

    public boolean equals(Object obj) {
        throw new AssertionFailure("this type can not be compared reliably");
    }

    public int hashCode() {
        throw new AssertionFailure("this type can not be compared reliably");
    }

    @Override
    public void stop() {
        int readCurrentState = this.current;
        this.timer.cancel();
        this.task.stop();
        try {
            this.directory.close();
        }
        catch (Exception e) {
            log.unableToCloseLuceneDirectory(this.directory.getDirectory(), e);
        }
    }

    private class CopyDirectory
    implements Runnable {
        private final Path source;
        private final Path destination;
        private final AtomicBoolean inProgress = new AtomicBoolean(false);

        public CopyDirectory(Path source, Path destination) {
            this.source = source;
            this.destination = destination;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FSMasterDirectoryProvider.this.directoryProviderLock.lock();
            boolean traceEnabled = log.isTraceEnabled();
            try {
                int oldIndex;
                long startTime = 0L;
                if (traceEnabled) {
                    startTime = System.nanoTime();
                }
                int index = (oldIndex = FSMasterDirectoryProvider.this.current) == 1 ? 2 : 1;
                Path destinationFile = this.destination.resolve(Integer.valueOf(index).toString());
                try {
                    log.tracef("Copying %s into %s", (Object)this.source, (Object)destinationFile);
                    FileHelper.synchronize(this.source, destinationFile, true);
                    FSMasterDirectoryProvider.this.current = index;
                }
                catch (IOException e) {
                    log.unableToSynchronizeSource(FSMasterDirectoryProvider.this.indexDir.toString(), e);
                    FSMasterDirectoryProvider.this.directoryProviderLock.unlock();
                    this.inProgress.set(false);
                    return;
                }
                try {
                    Files.delete(this.destination.resolve(CURRENT_DIR_NAME[oldIndex]));
                }
                catch (IOException e) {
                    log.unableToRemovePreviousMarker(FSMasterDirectoryProvider.this.indexDir.toString(), e);
                }
                try {
                    Files.createFile(this.destination.resolve(CURRENT_DIR_NAME[index]), new FileAttribute[0]);
                }
                catch (IOException e) {
                    log.unableToCreateCurrentMarker(FSMasterDirectoryProvider.this.indexDir.toString(), e);
                }
                if (traceEnabled) {
                    log.tracef("Copy for %s took %d ms", (Object)FSMasterDirectoryProvider.this.indexDir.toString(), (Object)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime));
                }
            }
            finally {
                FSMasterDirectoryProvider.this.directoryProviderLock.unlock();
                this.inProgress.set(false);
            }
        }
    }

    private class TriggerTask
    extends TimerTask {
        private final ExecutorService executor = Executors.newSingleThreadExecutor();
        private final CopyDirectory copyTask;

        public TriggerTask(Path source, Path destination) {
            this.copyTask = new CopyDirectory(source, destination);
        }

        @Override
        public void run() {
            if (this.copyTask.inProgress.compareAndSet(false, true)) {
                this.executor.execute(this.copyTask);
            } else {
                log.skippingDirectorySynchronization(FSMasterDirectoryProvider.this.indexDir.toString());
            }
        }

        public void stop() {
            this.executor.shutdownNow();
        }
    }
}

