/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.stat.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.hibernate.search.engine.Version;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.service.classloading.spi.ClassLoadingException;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.spi.StatisticsImplementor;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class StatisticsImpl
implements Statistics,
StatisticsImplementor {
    private LongAdder searchQueryCount = new LongAdder();
    private LongAdder searchExecutionTotalTime = new LongAdder();
    private AtomicLong searchExecutionMaxTime = new AtomicLong();
    private volatile String queryExecutionMaxTimeQueryString;
    private LongAdder objectLoadedCount = new LongAdder();
    private LongAdder objectLoadTotalTime = new LongAdder();
    private AtomicLong objectLoadMaxTime = new AtomicLong();
    private volatile boolean isStatisticsEnabled;
    private final Lock sharedLock;
    private final Lock exclusiveLock;
    private final ExtendedSearchIntegrator extendedIntegrator;

    public StatisticsImpl(ExtendedSearchIntegrator extendedIntegrator) {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.sharedLock = lock.readLock();
        this.exclusiveLock = lock.writeLock();
        this.extendedIntegrator = extendedIntegrator;
    }

    @Override
    public void clear() {
        this.searchQueryCount.reset();
        this.searchExecutionTotalTime.reset();
        this.searchExecutionMaxTime.set(0L);
        this.queryExecutionMaxTimeQueryString = "";
        this.objectLoadedCount.reset();
        this.objectLoadMaxTime.set(0L);
        this.objectLoadTotalTime.reset();
    }

    @Override
    public long getSearchQueryExecutionCount() {
        return this.searchQueryCount.longValue();
    }

    @Override
    public long getSearchQueryTotalTime() {
        return this.searchExecutionTotalTime.longValue();
    }

    @Override
    public long getSearchQueryExecutionMaxTime() {
        return this.searchExecutionMaxTime.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSearchQueryExecutionAvgTime() {
        long searchExecutionTotalTimeLocal;
        long searchQueryCountLocal;
        this.exclusiveLock.lock();
        try {
            searchQueryCountLocal = this.searchQueryCount.longValue();
            searchExecutionTotalTimeLocal = this.searchExecutionTotalTime.longValue();
        }
        finally {
            this.exclusiveLock.unlock();
        }
        long avgExecutionTime = 0L;
        if (searchQueryCountLocal > 0L) {
            avgExecutionTime = searchExecutionTotalTimeLocal / searchQueryCountLocal;
        }
        return avgExecutionTime;
    }

    @Override
    public String getSearchQueryExecutionMaxTimeQueryString() {
        return this.queryExecutionMaxTimeQueryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void searchExecuted(String searchString, long time) {
        this.sharedLock.lock();
        try {
            boolean isLongestQuery = false;
            long old = this.searchExecutionMaxTime.get();
            while (time > old && (isLongestQuery = this.searchExecutionMaxTime.compareAndSet(old, time))) {
                old = this.searchExecutionMaxTime.get();
            }
            if (isLongestQuery) {
                this.queryExecutionMaxTimeQueryString = searchString;
            }
            this.searchQueryCount.increment();
            this.searchExecutionTotalTime.add(time);
        }
        finally {
            this.sharedLock.unlock();
        }
    }

    @Override
    public long getObjectsLoadedCount() {
        return this.objectLoadedCount.longValue();
    }

    @Override
    public long getObjectLoadingTotalTime() {
        return this.objectLoadTotalTime.longValue();
    }

    @Override
    public long getObjectLoadingExecutionMaxTime() {
        return this.objectLoadMaxTime.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getObjectLoadingExecutionAvgTime() {
        this.exclusiveLock.lock();
        try {
            long avgLoadingTime = 0L;
            long currentObjectLoadedCount = this.objectLoadedCount.longValue();
            if (currentObjectLoadedCount > 0L) {
                avgLoadingTime = this.objectLoadTotalTime.longValue() / currentObjectLoadedCount;
            }
            long l = avgLoadingTime;
            return l;
        }
        finally {
            this.exclusiveLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void objectLoadExecuted(long numberOfObjectsLoaded, long time) {
        this.sharedLock.lock();
        try {
            long old = this.objectLoadMaxTime.longValue();
            while (time > old && this.objectLoadMaxTime.compareAndSet(old, time)) {
                old = this.objectLoadMaxTime.longValue();
            }
            this.objectLoadedCount.add(numberOfObjectsLoaded);
            this.objectLoadTotalTime.add(time);
        }
        finally {
            this.sharedLock.unlock();
        }
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.isStatisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean b) {
        this.isStatisticsEnabled = b;
    }

    @Override
    public String getSearchVersion() {
        return Version.getVersionString();
    }

    @Override
    public Set<String> getIndexedClassNames() {
        HashSet<String> indexedClasses = new HashSet<String>();
        for (IndexedTypeIdentifier clazz : this.extendedIntegrator.getIndexBindings().keySet()) {
            indexedClasses.add(clazz.getName());
        }
        return indexedClasses;
    }

    @Override
    public int getNumberOfIndexedEntities(String entity) {
        Class<?> clazz = this.getEntityClass(entity);
        IndexReader indexReader = this.extendedIntegrator.getIndexReaderAccessor().open(clazz);
        try {
            IndexSearcher searcher = new IndexSearcher(indexReader);
            BooleanQuery boolQuery = new BooleanQuery.Builder().add(new MatchAllDocsQuery(), BooleanClause.Occur.FILTER).add(new TermQuery(new Term("_hibernate_class", entity)), BooleanClause.Occur.FILTER).build();
            try {
                TopDocs topdocs = searcher.search((Query)boolQuery, 1);
                int n = topdocs.totalHits;
                return n;
            }
            catch (IOException e) {
                throw new SearchException("Unable to execute count query for entity " + entity, e);
            }
        }
        finally {
            this.extendedIntegrator.getIndexReaderAccessor().close(indexReader);
        }
    }

    @Override
    public Map<String, Integer> indexedEntitiesCount() {
        HashMap<String, Integer> countPerEntity = new HashMap<String, Integer>();
        for (String className : this.getIndexedClassNames()) {
            countPerEntity.put(className, this.getNumberOfIndexedEntities(className));
        }
        return countPerEntity;
    }

    private Class<?> getEntityClass(String entity) {
        Class clazz;
        try {
            clazz = ClassLoaderHelper.classForName(entity, this.extendedIntegrator.getServiceManager());
        }
        catch (ClassLoadingException e) {
            throw new IllegalArgumentException(entity + "not a indexed entity");
        }
        return clazz;
    }

    @Override
    public long getIndexSize(String indexName) {
        IndexManager indexManager = this.extendedIntegrator.getIndexManager(indexName);
        if (indexManager == null) {
            throw new IllegalArgumentException("'" + indexName + "' is not a known index");
        }
        return this.getIndexSize(indexManager);
    }

    @Override
    public Map<String, Long> indexSizes() {
        return this.extendedIntegrator.getIndexManagerHolder().getIndexManagers().stream().collect(Collectors.toMap(IndexManager::getIndexName, this::getIndexSize));
    }

    private long getIndexSize(IndexManager indexManager) {
        if (!(indexManager instanceof DirectoryBasedIndexManager)) {
            throw new IllegalArgumentException("Index '" + indexManager.getIndexName() + "' is not a Lucene index");
        }
        DirectoryBasedIndexManager directoryBasedIndexManager = (DirectoryBasedIndexManager)indexManager;
        Object directory = directoryBasedIndexManager.getDirectoryProvider().getDirectory();
        long totalSize = 0L;
        try {
            for (String fileName : ((Directory)directory).listAll()) {
                try {
                    totalSize += ((Directory)directory).fileLength(fileName);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            throw new SearchException("Unexpected exception while computing size of index '" + indexManager.getIndexName() + "'", e);
        }
        return totalSize;
    }
}

