/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class TypeHierarchy {
    private static final Log log = LoggerFactory.make();
    private Map<Class<?>, Set<IndexedTypeIdentifier>> classToConfiguredClass = new HashMap();

    public void addConfiguredClass(Class<?> configuredClass) {
        this.addClass(configuredClass, configuredClass);
        for (Class<?> superClass = configuredClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            this.addClass(superClass, configuredClass);
        }
        for (Class<?> clazz : configuredClass.getInterfaces()) {
            this.addClass(clazz, configuredClass);
        }
    }

    private void addClass(Class<?> superclass, Class<?> indexedClass) {
        Set<IndexedTypeIdentifier> classesSet = this.classToConfiguredClass.get(superclass);
        if (classesSet == null) {
            classesSet = new HashSet<IndexedTypeIdentifier>();
            this.classToConfiguredClass.put(superclass, classesSet);
        }
        classesSet.add(new PojoIndexedTypeIdentifier(indexedClass));
    }

    public IndexedTypeSet getConfiguredClasses(IndexedTypeSet types) {
        if (types == null) {
            return IndexedTypeSets.empty();
        }
        HashSet<IndexedTypeIdentifier> indexedClasses = new HashSet<IndexedTypeIdentifier>();
        for (IndexedTypeIdentifier type : types) {
            Class<?> clazz = type.getPojoType();
            Set<IndexedTypeIdentifier> set = this.classToConfiguredClass.get(clazz);
            if (set == null) continue;
            indexedClasses.addAll(set);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Targeted indexed classes for %s: %s", (Object)types, (Object)indexedClasses);
        }
        return IndexedTypeSets.fromIdentifiers(indexedClasses);
    }
}

