/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.util.List;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.DistanceQuery;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.Rectangle;
import org.hibernate.search.spatial.impl.SpatialHashQuery;
import org.hibernate.search.spatial.impl.SpatialHelper;

public abstract class SpatialQueryBuilderFromCoordinates {
    public static Query buildSpatialHashQuery(Coordinates center, double radius, String fieldName) {
        int bestSpatialHashLevel = SpatialHelper.findBestSpatialHashLevelForSearchRange(2.0 * radius);
        if (bestSpatialHashLevel > 16) {
            bestSpatialHashLevel = 16;
        }
        List<String> spatialHashCellsIds = SpatialHelper.getSpatialHashCellsIds(center, radius, bestSpatialHashLevel);
        return new SpatialHashQuery(spatialHashCellsIds, SpatialHelper.formatFieldName(bestSpatialHashLevel, fieldName));
    }

    public static Query buildDistanceQuery(Query approximationQuery, Coordinates center, double radius, String coordinatesField) {
        return new DistanceQuery(approximationQuery, center, radius, coordinatesField);
    }

    public static Query buildDistanceQuery(Query approximationQuery, Coordinates center, double radius, String latitudeField, String longitudeField) {
        return new DistanceQuery(approximationQuery, center, radius, latitudeField, longitudeField);
    }

    public static Query buildDistanceQuery(Coordinates center, double radius, String fieldName) {
        return SpatialQueryBuilderFromCoordinates.buildDistanceQuery(null, center, radius, fieldName);
    }

    public static Query buildSpatialQueryByHash(Coordinates center, double radius, String fieldName) {
        return SpatialQueryBuilderFromCoordinates.buildDistanceQuery(SpatialQueryBuilderFromCoordinates.buildSpatialHashQuery(center, radius, fieldName), center, radius, fieldName);
    }

    public static Query buildSpatialQueryByRange(Coordinates centerCoordinates, double radius, String fieldName) {
        Point center = Point.fromCoordinates(centerCoordinates);
        Rectangle boundingBox = Rectangle.fromBoundingCircle(center, radius);
        String latitudeFieldName = fieldName + "_HSSI_Latitude";
        String longitudeFieldName = fieldName + "_HSSI_Longitude";
        NumericRangeQuery<Double> latQuery = NumericRangeQuery.newDoubleRange(latitudeFieldName, boundingBox.getLowerLeft().getLatitude(), boundingBox.getUpperRight().getLatitude(), true, true);
        Query longQuery = null;
        longQuery = boundingBox.getLowerLeft().getLongitude() <= boundingBox.getUpperRight().getLongitude() ? NumericRangeQuery.newDoubleRange(longitudeFieldName, boundingBox.getLowerLeft().getLongitude(), boundingBox.getUpperRight().getLongitude(), true, true) : new BooleanQuery.Builder().add(NumericRangeQuery.newDoubleRange(longitudeFieldName, boundingBox.getLowerLeft().getLongitude(), 180.0, true, true), BooleanClause.Occur.SHOULD).add(NumericRangeQuery.newDoubleRange(longitudeFieldName, -180.0, boundingBox.getUpperRight().getLongitude(), true, true), BooleanClause.Occur.SHOULD).build();
        BooleanQuery boxQuery = new BooleanQuery.Builder().add(latQuery, BooleanClause.Occur.FILTER).add(longQuery, BooleanClause.Occur.FILTER).build();
        return SpatialQueryBuilderFromCoordinates.buildDistanceQuery(boxQuery, center, radius, latitudeFieldName, longitudeFieldName);
    }
}

