/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.FixedBitSet;
import org.hibernate.search.spatial.impl.ConstantScoreScorer;
import org.hibernate.search.spatial.impl.ConstantScoreWeight;

public final class SpatialHashQuery
extends Query {
    private final List<String> spatialHashCellsIds;
    private final String fieldName;

    public SpatialHashQuery(List<String> spatialHashCellsIds, String fieldName) {
        this.spatialHashCellsIds = spatialHashCellsIds;
        this.fieldName = fieldName;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSetIterator iterator = SpatialHashQuery.this.createDocIdSetIterator(context);
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }

    private DocIdSetIterator createDocIdSetIterator(LeafReaderContext context) throws IOException {
        if (this.spatialHashCellsIds.size() == 0) {
            return null;
        }
        LeafReader atomicReader = context.reader();
        BitDocIdSet matchedDocumentsIds = new BitDocIdSet(new FixedBitSet(atomicReader.maxDoc()));
        boolean found = false;
        for (int i = 0; i < this.spatialHashCellsIds.size(); ++i) {
            int docId;
            Term spatialHashCellTerm = new Term(this.fieldName, this.spatialHashCellsIds.get(i));
            PostingsEnum spatialHashCellsDocs = atomicReader.postings(spatialHashCellTerm);
            if (spatialHashCellsDocs == null) continue;
            while ((docId = spatialHashCellsDocs.nextDoc()) != Integer.MAX_VALUE) {
                matchedDocumentsIds.bits().set(docId);
                found = true;
            }
        }
        if (found) {
            return matchedDocumentsIds.iterator();
        }
        return DocIdSetIterator.empty();
    }

    public List<String> getSpatialHashCellsIds() {
        return Collections.unmodifiableList(this.spatialHashCellsIds);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public int hashCode() {
        int hashCode = 31 * super.hashCode() + this.spatialHashCellsIds.hashCode();
        hashCode = 31 * hashCode + this.fieldName.hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SpatialHashQuery) {
            SpatialHashQuery other = (SpatialHashQuery)obj;
            return this.spatialHashCellsIds.equals(other.spatialHashCellsIds) && this.fieldName.equals(other.fieldName);
        }
        return false;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("SpatialHashFilter");
        sb.append("{spatialHashCellsIds=").append(this.spatialHashCellsIds);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

