/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.ConstantScoreScorer;
import org.hibernate.search.spatial.impl.ConstantScoreWeight;
import org.hibernate.search.spatial.impl.CoordinateHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceQuery
extends Query {
    private final Query approximationQuery;
    private final Point center;
    private final double radius;
    private final String coordinatesField;
    private final String latitudeField;
    private final String longitudeField;

    public DistanceQuery(Query approximationQuery, Coordinates centerCoordinates, double radius, String coordinatesField) {
        this(approximationQuery, centerCoordinates, radius, coordinatesField, null, null);
    }

    public DistanceQuery(Query approximationQuery, Coordinates centerCoordinates, double radius, String latitudeField, String longitudeField) {
        this(approximationQuery, centerCoordinates, radius, null, latitudeField, longitudeField);
    }

    private DistanceQuery(Query approximationQuery, Coordinates centerCoordinates, double radius, String coordinatesField, String latitudeField, String longitudeField) {
        this.approximationQuery = approximationQuery == null ? new MatchAllDocsQuery() : approximationQuery;
        this.center = Point.fromCoordinates(centerCoordinates);
        this.radius = radius;
        this.coordinatesField = coordinatesField;
        this.latitudeField = latitudeField;
        this.longitudeField = longitudeField;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query superRewritten = super.rewrite(reader);
        if (superRewritten != this) {
            return superRewritten;
        }
        Query rewrittenApproximationQuery = this.approximationQuery.rewrite(reader);
        if (rewrittenApproximationQuery != this.approximationQuery) {
            DistanceQuery clone = new DistanceQuery(rewrittenApproximationQuery, this.center, this.radius, this.coordinatesField, this.latitudeField, this.longitudeField);
            return clone;
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight approximationWeight = this.approximationQuery.createWeight(searcher, needsScores);
        return new ConstantScoreWeight(this){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                Scorer approximationScorer = approximationWeight.scorer(context);
                if (approximationScorer == null) {
                    return null;
                }
                DocIdSetIterator approximation = approximationScorer.iterator();
                TwoPhaseIterator iterator = DistanceQuery.this.createDocIdSetIterator(approximation, context);
                return new ConstantScoreScorer((Weight)this, this.score(), iterator);
            }
        };
    }

    private TwoPhaseIterator createDocIdSetIterator(DocIdSetIterator approximation, final LeafReaderContext context) throws IOException {
        return new TwoPhaseIterator(approximation){
            private Bits docsWithLatitude;
            private Bits docsWithLongitude;
            private NumericDocValues latitudeValues;
            private NumericDocValues longitudeValues;

            private void lazyInit() throws IOException {
                if (this.docsWithLatitude != null) {
                    return;
                }
                LeafReader atomicReader = context.reader();
                this.docsWithLatitude = DocValues.getDocsWithField(atomicReader, DistanceQuery.this.getLatitudeField());
                this.docsWithLongitude = DocValues.getDocsWithField(atomicReader, DistanceQuery.this.getLongitudeField());
                this.latitudeValues = DocValues.getNumeric(atomicReader, DistanceQuery.this.getLatitudeField());
                this.longitudeValues = DocValues.getNumeric(atomicReader, DistanceQuery.this.getLongitudeField());
            }

            @Override
            public boolean matches() throws IOException {
                this.lazyInit();
                int docID = this.approximation().docID();
                if (this.docsWithLatitude.get(docID) && this.docsWithLongitude.get(docID)) {
                    double lat = CoordinateHelper.coordinate(this.latitudeValues, docID);
                    double lon = CoordinateHelper.coordinate(this.longitudeValues, docID);
                    if (DistanceQuery.this.center.getDistanceTo(lat, lon) <= DistanceQuery.this.radius) {
                        return true;
                    }
                }
                return false;
            }

            @Override
            public float matchCost() {
                return 100.0f;
            }
        };
    }

    public String getCoordinatesField() {
        if (this.coordinatesField != null) {
            return this.coordinatesField;
        }
        return SpatialHelper.stripSpatialFieldSuffix(this.latitudeField);
    }

    public double getRadius() {
        return this.radius;
    }

    public Point getCenter() {
        return this.center;
    }

    public Query getApproximationQuery() {
        return this.approximationQuery;
    }

    private String getLatitudeField() {
        if (this.latitudeField != null) {
            return this.latitudeField;
        }
        return SpatialHelper.formatLatitude(this.coordinatesField);
    }

    private String getLongitudeField() {
        if (this.longitudeField != null) {
            return this.longitudeField;
        }
        return SpatialHelper.formatLongitude(this.coordinatesField);
    }

    @Override
    public int hashCode() {
        int hashCode = 31 * super.hashCode() + this.approximationQuery.hashCode();
        hashCode = 31 * hashCode + this.center.hashCode();
        hashCode = 31 * hashCode + Double.hashCode(this.radius);
        hashCode = 31 * hashCode + Objects.hashCode(this.coordinatesField);
        hashCode = 31 * hashCode + Objects.hashCode(this.latitudeField);
        hashCode = 31 * hashCode + Objects.hashCode(this.longitudeField);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof DistanceQuery) {
            DistanceQuery other = (DistanceQuery)obj;
            return Float.floatToIntBits(this.getBoost()) == Float.floatToIntBits(other.getBoost()) && this.approximationQuery.equals(other.approximationQuery) && this.center.equals(other.center) && this.radius == other.radius && Objects.equals(this.coordinatesField, other.coordinatesField) && Objects.equals(this.latitudeField, other.latitudeField) && Objects.equals(this.longitudeField, other.longitudeField);
        }
        return false;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("DistanceQuery");
        sb.append("{approximationQuery=").append(this.approximationQuery);
        sb.append(", center=").append(this.center);
        sb.append(", radius=").append(this.radius);
        if (this.coordinatesField != null) {
            sb.append(", coordinatesField='").append(this.coordinatesField).append('\'');
        } else {
            sb.append(", latitudeField=").append(this.latitudeField);
            sb.append(", longitudeField=").append(this.longitudeField).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }
}

