/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.Bits;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.CoordinateHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public class DistanceCollector
implements Collector {
    private final Point center;
    private final SpatialResultsCollector distances;
    private final String latitudeField;
    private final String longitudeField;

    public DistanceCollector(Coordinates centerCoordinates, int hitsCount, String fieldname) {
        this.center = Point.fromCoordinates(centerCoordinates);
        this.distances = new SpatialResultsCollector(hitsCount);
        this.latitudeField = SpatialHelper.formatLatitude(fieldname);
        this.longitudeField = SpatialHelper.formatLongitude(fieldname);
    }

    public Double getDistance(int index) {
        return this.distances.get(index, this.center);
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        return new DistanceLeafCollector(context);
    }

    @Override
    public boolean needsScores() {
        return false;
    }

    private class DistanceLeafCollector
    implements LeafCollector {
        private final int docBase;
        private final Bits docsWithLatitude;
        private final Bits docsWithLongitude;
        private final NumericDocValues latitudeValues;
        private final NumericDocValues longitudeValues;

        DistanceLeafCollector(LeafReaderContext context) throws IOException {
            LeafReader atomicReader = context.reader();
            this.docsWithLatitude = DocValues.getDocsWithField(atomicReader, DistanceCollector.this.latitudeField);
            this.docsWithLongitude = DocValues.getDocsWithField(atomicReader, DistanceCollector.this.longitudeField);
            this.latitudeValues = DocValues.getNumeric(atomicReader, DistanceCollector.this.latitudeField);
            this.longitudeValues = DocValues.getNumeric(atomicReader, DistanceCollector.this.longitudeField);
            this.docBase = context.docBase;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        public void collect(int doc) throws IOException {
            int absolute = this.docBase + doc;
            if (this.docsWithLatitude.get(doc) && this.docsWithLongitude.get(doc)) {
                double lat = CoordinateHelper.coordinate(this.latitudeValues, doc);
                double lon = CoordinateHelper.coordinate(this.longitudeValues, doc);
                DistanceCollector.this.distances.put(absolute, lat, lon);
            } else {
                DistanceCollector.this.distances.putIncomplete(absolute);
            }
        }
    }

    private static class SpatialResultsCollector {
        final ArrayList<HitEntry> orderedEntries;
        int currentIterator = 0;

        private SpatialResultsCollector(int size) {
            this.orderedEntries = new ArrayList(size);
        }

        public Double get(int index, Point center) {
            HitEntry currentEntry;
            int startingPoint = this.currentIterator;
            while (this.currentIterator < this.orderedEntries.size() && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            this.currentIterator = 0;
            while (this.currentIterator < startingPoint && (currentEntry = this.orderedEntries.get(this.currentIterator)) != null) {
                if (currentEntry.documentId == index) {
                    return currentEntry.getDistance(center);
                }
                ++this.currentIterator;
            }
            throw new SearchException("Unexpected index: this documentId was not collected");
        }

        void put(int documentId, double latitude, double longitude) {
            this.orderedEntries.add(new CompleteHitEntry(documentId, latitude, longitude));
        }

        void putIncomplete(int documentId) {
            this.orderedEntries.add(new IncompleteHitEntry(documentId));
        }
    }

    private static final class IncompleteHitEntry
    extends HitEntry {
        private IncompleteHitEntry(int documentId) {
            super(documentId);
        }

        @Override
        Double getDistance(Point center) {
            return null;
        }
    }

    private static final class CompleteHitEntry
    extends HitEntry {
        double latitude;
        double longitude;

        private CompleteHitEntry(int documentId, double latitude, double longitude) {
            super(documentId);
            this.latitude = latitude;
            this.longitude = longitude;
        }

        @Override
        Double getDistance(Point center) {
            return center.getDistanceTo(this.latitude, this.longitude);
        }
    }

    private static abstract class HitEntry {
        int documentId;

        private HitEntry(int documentId) {
            this.documentId = documentId;
        }

        abstract Double getDistance(Point var1);
    }
}

