/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.engine.impl;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.util.Counter;
import org.hibernate.search.engine.spi.TimingSource;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.query.engine.spi.TimeoutManager;

public class TimeoutManagerImpl
implements TimeoutManager {
    private Long timeout;
    private long start;
    boolean timedOut = false;
    private final Object query;
    private TimeoutManager.Type type;
    private boolean partialResults;
    private final TimeoutExceptionFactory timeoutExceptionFactory;
    private final TimingSource timingSource;

    public TimeoutManagerImpl(Object query, TimeoutExceptionFactory timeoutExceptionFactory, TimingSource timingSource) {
        this.query = query;
        this.timeoutExceptionFactory = timeoutExceptionFactory;
        this.timingSource = timingSource;
    }

    @Override
    public void start() {
        if (this.timeout == null) {
            return;
        }
        this.start = System.nanoTime();
        this.partialResults = false;
    }

    @Override
    public Long getTimeoutLeftInMilliseconds() {
        return this.getTimeoutLeft(1000000L);
    }

    @Override
    public Long getTimeoutLeftInSeconds() {
        return this.getTimeoutLeft(1000000000L);
    }

    private Long getTimeoutLeft(long factor) {
        if (this.timeout == null) {
            return null;
        }
        long currentTime = System.nanoTime();
        if (this.isTimedOut(currentTime)) {
            return 0L;
        }
        long left = this.timeout - (currentTime - this.start);
        long result = left % factor == 0L ? left / factor : left / factor + 1L;
        if (result <= 0L) {
            return 0L;
        }
        return result;
    }

    @Override
    public boolean isTimedOut() {
        if (this.timeout == null) {
            return false;
        }
        if (this.timedOut) {
            return true;
        }
        return this.isTimedOut(System.nanoTime());
    }

    private boolean isTimedOut(long currentTime) {
        if (this.timeout == null) {
            return false;
        }
        if (this.timedOut) {
            return true;
        }
        long elapsedTime = currentTime - this.start;
        boolean bl = this.timedOut = elapsedTime > this.timeout;
        if (this.type != TimeoutManager.Type.LIMIT && this.timedOut) {
            throw this.timeoutExceptionFactory.createTimeoutException("Full-text query took longer than expected (in microsecond): " + TimeUnit.NANOSECONDS.toMicros(elapsedTime), String.valueOf(this.query));
        }
        return this.timedOut;
    }

    @Override
    public void stop() {
        this.timeout = null;
        this.type = TimeoutManager.Type.NONE;
    }

    @Override
    public void setTimeout(long timeout, TimeUnit timeUnit) {
        this.timeout = timeUnit.toNanos(timeout);
        if (timeout == 0L) {
            this.stop();
        }
    }

    public void forceTimedOut() {
        this.timedOut = Boolean.TRUE;
        if (this.type == TimeoutManager.Type.LIMIT) {
            this.partialResults = true;
        }
    }

    @Override
    public void raiseExceptionOnTimeout() {
        if (this.type == TimeoutManager.Type.LIMIT) {
            throw new SearchException("Cannot define both setTimeout and limitFetchingTime on a full-text query. Please report your need to the Hibernate team");
        }
        this.type = TimeoutManager.Type.EXCEPTION;
    }

    @Override
    public void limitFetchingOnTimeout() {
        if (this.type == TimeoutManager.Type.EXCEPTION) {
            throw new SearchException("Cannot define both setTimeout and limitFetchingTime on a full-text query. Please report your need to the Hibernate team");
        }
        this.type = TimeoutManager.Type.LIMIT;
    }

    @Override
    public void reactOnQueryTimeoutExceptionWhileExtracting(RuntimeException e) {
        if (this.type != TimeoutManager.Type.LIMIT) {
            if (e == null) {
                e = this.timeoutExceptionFactory.createTimeoutException("Timeout period exceeded", String.valueOf(this.query));
            }
            throw e;
        }
        this.partialResults = true;
    }

    @Override
    public boolean hasPartialResults() {
        return this.partialResults;
    }

    @Override
    public TimeoutManager.Type getType() {
        return this.type;
    }

    public Counter getLuceneTimeoutCounter() {
        this.timingSource.ensureInitialized();
        return new LuceneCounterAdapter(this.timingSource);
    }

    private static final class LuceneCounterAdapter
    extends Counter {
        private final TimingSource timingSource;

        public LuceneCounterAdapter(TimingSource timingSource) {
            this.timingSource = timingSource;
        }

        @Override
        public long addAndGet(long delta) {
            return this.timingSource.getMonotonicTimeEstimate();
        }

        @Override
        public long get() {
            return this.timingSource.getMonotonicTimeEstimate();
        }
    }
}

