/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.sort.impl;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.hibernate.search.exception.SearchException;

public class NativeSortField
extends SortField {
    private static final FieldComparatorSource FAILING_COMPARATOR_SOURCE = new FieldComparatorSource(){

        @Override
        public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
            throw new SearchException("This sort field should never have been executed in the first place. This is probably a result of queryBuilder.sort().byNative(String) being called while using the Lucene backend. This method is only provided for use with the Elasticsearch backend.");
        }
    };
    private final String nativeSortDescription;

    public NativeSortField(String fieldName, String nativeSortFieldDescription) {
        super(fieldName, FAILING_COMPARATOR_SOURCE);
        this.nativeSortDescription = nativeSortFieldDescription;
    }

    public String getNativeSortDescription() {
        return this.nativeSortDescription;
    }
}

