/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.exception.AssertionFailure;

public class RemoteSimpleQueryStringQuery
extends Query {
    private final String query;
    private final List<Field> fields;
    private final boolean withAndAsDefaultOperator;
    private final RemoteAnalyzerReference originalRemoteAnalyzerReference;
    private final RemoteAnalyzerReference queryRemoteAnalyzerReference;

    private RemoteSimpleQueryStringQuery(String query, List<Field> fields, boolean withAndAsDefaultOperator, RemoteAnalyzerReference originalRemoteAnalyzerReference, RemoteAnalyzerReference queryRemoteAnalyzerReference) {
        if (fields.size() == 0) {
            throw new AssertionFailure("At least one field should be defined for a " + RemoteSimpleQueryStringQuery.class.getSimpleName());
        }
        this.query = query;
        this.fields = Collections.unmodifiableList(fields);
        this.withAndAsDefaultOperator = withAndAsDefaultOperator;
        this.originalRemoteAnalyzerReference = originalRemoteAnalyzerReference;
        this.queryRemoteAnalyzerReference = queryRemoteAnalyzerReference;
    }

    public String getQuery() {
        return this.query;
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public boolean isMatchAll() {
        return this.withAndAsDefaultOperator;
    }

    public RemoteAnalyzerReference getOriginalRemoteAnalyzerReference() {
        return this.originalRemoteAnalyzerReference;
    }

    public RemoteAnalyzerReference getQueryRemoteAnalyzerReference() {
        return this.queryRemoteAnalyzerReference;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("<");
        sb.append("query:").append(this.query).append(", ");
        sb.append("fields:").append(this.fields).append(", ");
        sb.append("withAndAsDefaultOperator:").append(this.withAndAsDefaultOperator).append(", ");
        sb.append("originalRemoteAnalyzerReference:").append(this.originalRemoteAnalyzerReference).append(", ");
        sb.append("queryRemoteAnalyzerReference:").append(this.queryRemoteAnalyzerReference);
        sb.append(">");
        return sb.toString();
    }

    public static class Field {
        private final String name;
        private final float boost;

        private Field(String name, float boost) {
            this.name = name;
            this.boost = boost;
        }

        public String getName() {
            return this.name;
        }

        public float getBoost() {
            return this.boost;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.name);
            if (this.boost != 1.0f) {
                sb.append("^").append(this.boost);
            }
            return sb.toString();
        }
    }

    public static class Builder {
        private String query;
        private List<Field> fields = new ArrayList<Field>();
        private boolean withAndAsDefaultOperator;
        private RemoteAnalyzerReference originalRemoteAnalyzerReference;
        private RemoteAnalyzerReference queryRemoteAnalyzerReference;

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder field(String name, float boost) {
            this.fields.add(new Field(name, boost));
            return this;
        }

        public Builder withAndAsDefaultOperator(boolean withAndAsDefaultOperator) {
            this.withAndAsDefaultOperator = withAndAsDefaultOperator;
            return this;
        }

        public Builder originalRemoteAnalyzerReference(RemoteAnalyzerReference originalRemoteAnalyzerReference) {
            this.originalRemoteAnalyzerReference = originalRemoteAnalyzerReference;
            return this;
        }

        public Builder queryRemoteAnalyzerReference(RemoteAnalyzerReference queryRemoteAnalyzerReference) {
            this.queryRemoteAnalyzerReference = queryRemoteAnalyzerReference;
            return this;
        }

        public RemoteSimpleQueryStringQuery build() {
            return new RemoteSimpleQueryStringQuery(this.query, this.fields, this.withAndAsDefaultOperator, this.originalRemoteAnalyzerReference, this.queryRemoteAnalyzerReference);
        }
    }
}

