/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.util.ToStringUtils;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.query.dsl.impl.AbstractRemoteQueryWithAnalyzer;

public class RemoteMatchQuery
extends AbstractRemoteQueryWithAnalyzer {
    private String field;
    private String searchTerms;
    private int maxEditDistance = 0;

    private RemoteMatchQuery(String field, String terms, int maxEditDistance, RemoteAnalyzerReference originalAnalyzerReference, RemoteAnalyzerReference queryAnalyzerReference) {
        super(originalAnalyzerReference, queryAnalyzerReference);
        this.field = field;
        this.maxEditDistance = maxEditDistance;
        this.searchTerms = terms;
    }

    public String getField() {
        return this.field;
    }

    public String getSearchTerms() {
        return this.searchTerms;
    }

    public int getMaxEditDistance() {
        return this.maxEditDistance;
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("<");
        sb.append(field).append(":");
        sb.append(this.searchTerms);
        if (this.maxEditDistance != 0) {
            sb.append("~").append(this.maxEditDistance);
        }
        sb.append(ToStringUtils.boost(this.getBoost()));
        sb.append(", originalAnalyzer=").append(this.getOriginalAnalyzerReference());
        sb.append(", queryAnalyzer=").append(this.getQueryAnalyzerReference());
        sb.append(">");
        return sb.toString();
    }

    public static class Builder {
        private String field;
        private String searchTerms;
        private int maxEditDistance = 0;
        private RemoteAnalyzerReference originalAnalyzerReference;
        private RemoteAnalyzerReference queryAnalyzerReference;

        public Builder field(String field) {
            this.field = field;
            return this;
        }

        public Builder searchTerms(String terms) {
            this.searchTerms = terms;
            return this;
        }

        public Builder maxEditDistance(int maxEditDistance) {
            this.maxEditDistance = maxEditDistance;
            return this;
        }

        public Builder analyzerReference(RemoteAnalyzerReference originalAnalyzerReference, RemoteAnalyzerReference queryAnalyzerReference) {
            this.originalAnalyzerReference = originalAnalyzerReference;
            this.queryAnalyzerReference = queryAnalyzerReference;
            return this;
        }

        public RemoteMatchQuery build() {
            return new RemoteMatchQuery(this.field, this.searchTerms, this.maxEditDistance, this.originalAnalyzerReference, this.queryAnalyzerReference);
        }
    }
}

