/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermRangeQuery;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.query.dsl.impl.AbstractFacet;
import org.hibernate.search.query.dsl.impl.FacetRange;
import org.hibernate.search.query.facet.RangeFacet;

public class RangeFacetImpl<T>
extends AbstractFacet
implements RangeFacet<T> {
    private final FacetRange<T> range;
    private final int rangeIndex;

    RangeFacetImpl(String facetingName, String facetFieldName, String sourceFieldName, FacetRange<T> range, int count, int index) {
        super(facetingName, facetFieldName, sourceFieldName, range.getRangeString(), count);
        this.range = range;
        this.rangeIndex = index;
    }

    @Override
    public Query getFacetQuery() {
        Object minOrMax = this.getNonNullMinOrMax(this.range);
        if (NumericFieldUtils.requiresNumericRangeQuery(minOrMax)) {
            return NumericFieldUtils.createNumericRangeQuery(this.getSourceFieldName(), this.range.getMin(), this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        }
        if (minOrMax instanceof String) {
            return TermRangeQuery.newStringRange(this.getSourceFieldName(), (String)this.range.getMin(), (String)this.range.getMax(), this.range.isMinIncluded(), this.range.isMaxIncluded());
        }
        throw new AssertionFailure("Unsupported range type");
    }

    public int getRangeIndex() {
        return this.rangeIndex;
    }

    @Override
    public T getMin() {
        return this.range.getMin();
    }

    @Override
    public T getMax() {
        return this.range.getMax();
    }

    @Override
    public boolean isIncludeMin() {
        return this.range.isMinIncluded();
    }

    @Override
    public boolean isIncludeMax() {
        return this.range.isMaxIncluded();
    }

    private Object getNonNullMinOrMax(FacetRange<T> range) {
        T o = range.getMin();
        if (o == null) {
            o = range.getMax();
        }
        return o;
    }
}

