/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.avro.impl;

import infinispan.org.apache.avro.Protocol;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.indexes.serialization.avro.impl.AvroSerializationProvider;
import org.hibernate.search.indexes.serialization.avro.logging.impl.Log;
import org.hibernate.search.util.impl.Closeables;
import org.hibernate.search.util.impl.StreamHelper;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class ProtocolBuilderV1_0 {
    private static final String AVRO_SCHEMA_FILE_SUFFIX = ".avro";
    private static final String AVRO_PROTOCOL_FILE_SUFFIX = ".avpr";
    private static String V1_0_PATH = "org/hibernate/search/remote/codex/avro/v1_0/";
    private static final Log log = LoggerFactory.make(Log.class);
    private final Map<String, String> schemas = new HashMap<String, String>();

    ProtocolBuilderV1_0() {
    }

    Protocol build() {
        this.parseSchema("attribute/TokenTrackingAttribute");
        this.parseSchema("attribute/CharTermAttribute");
        this.parseSchema("attribute/PayloadAttribute");
        this.parseSchema("attribute/KeywordAttribute");
        this.parseSchema("attribute/PositionIncrementAttribute");
        this.parseSchema("attribute/FlagsAttribute");
        this.parseSchema("attribute/TypeAttribute");
        this.parseSchema("attribute/OffsetAttribute");
        this.parseSchema("field/TermVector");
        this.parseSchema("field/Index");
        this.parseSchema("field/Store");
        this.parseSchema("field/TokenStreamField");
        this.parseSchema("field/ReaderField");
        this.parseSchema("field/StringField");
        this.parseSchema("field/BinaryField");
        this.parseSchema("field/NumericIntField");
        this.parseSchema("field/NumericLongField");
        this.parseSchema("field/NumericFloatField");
        this.parseSchema("field/NumericDoubleField");
        this.parseSchema("field/CustomFieldable");
        this.parseSchema("Document");
        this.parseSchema("operation/Id");
        this.parseSchema("operation/OptimizeAll");
        this.parseSchema("operation/PurgeAll");
        this.parseSchema("operation/Delete");
        this.parseSchema("operation/Add");
        this.parseSchema("operation/Update");
        this.parseSchema("Message");
        return this.parseProtocol("Works");
    }

    protected final void parseSchema(String filename) {
        String fullFileName = this.getResourceBasePath() + filename + AVRO_SCHEMA_FILE_SUFFIX;
        String schema = ProtocolBuilderV1_0.avroResourceAsString(fullFileName);
        this.schemas.put(filename, schema);
    }

    protected String getResourceBasePath() {
        return V1_0_PATH;
    }

    protected final Protocol parseProtocol(String name) {
        String fullFileName = this.getResourceBasePath() + name + AVRO_PROTOCOL_FILE_SUFFIX;
        String protocolSkeleton = ProtocolBuilderV1_0.avroResourceAsString(fullFileName);
        String protocol = this.inlineSchemas(protocolSkeleton);
        return Protocol.parse(protocol);
    }

    private String inlineSchemas(String protocolSkeleton) {
        String result = protocolSkeleton;
        for (Map.Entry<String, String> entry : this.schemas.entrySet()) {
            result = ProtocolBuilderV1_0.replace(result, "`" + entry.getKey() + "`", entry.getValue());
        }
        return result;
    }

    private static String replace(String str, String pattern, String replace) {
        int e;
        int s = 0;
        StringBuilder result = new StringBuilder();
        while ((e = str.indexOf(pattern, s)) >= 0) {
            result.append(str.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(str.substring(s));
        return result.toString();
    }

    private static String avroResourceAsString(String resourceName) {
        String resource;
        InputStream inputStream = AvroSerializationProvider.class.getClassLoader().getResourceAsStream(resourceName);
        if (inputStream == null) {
            throw log.unableToLoadAvroSchema(resourceName);
        }
        try {
            resource = StreamHelper.readInputStream(inputStream);
        }
        catch (IOException e) {
            throw log.unableToLoadResource(resourceName);
        }
        finally {
            Closeables.closeQuietly(inputStream);
        }
        return resource;
    }
}

