/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.Executors;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class PeriodicRefreshingReaderProvider
implements DirectoryBasedReaderProvider {
    public static final int DEFAULT_ACCEPTABLE_MAX_AGE_MS = 5000;
    private static final Log log = LoggerFactory.make();
    protected final Map<IndexReader, ReaderUsagePair> allReaders = new ConcurrentHashMap<IndexReader, ReaderUsagePair>();
    protected final Map<Directory, PerDirectoryLatestReader> currentReaders = new ConcurrentHashMap<Directory, PerDirectoryLatestReader>();
    private volatile ScheduledExecutorService scheduledExecutorService;
    private int delay;
    private DirectoryProvider directoryProvider;
    private String indexName;

    @Override
    public IndexReader openIndexReader() {
        log.tracef("Opening IndexReader for directoryProvider %s", (Object)this.indexName);
        Object directory = this.directoryProvider.getDirectory();
        PerDirectoryLatestReader directoryLatestReader = this.currentReaders.get(directory);
        if (directoryLatestReader == null) {
            directoryLatestReader = this.createReader((Directory)directory);
        }
        return directoryLatestReader.getLatestReader();
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        if (reader == null) {
            return;
        }
        log.tracef("Closing IndexReader: %s", (Object)reader);
        ReaderUsagePair container = this.allReaders.get(reader);
        container.close();
    }

    protected DirectoryReader readerFactory(Directory directory) throws IOException {
        return DirectoryReader.open(directory);
    }

    @Override
    public void initialize(DirectoryBasedIndexManager indexManager, Properties props) {
        this.directoryProvider = indexManager.getDirectoryProvider();
        this.indexName = indexManager.getIndexName();
        this.createReader((Directory)this.directoryProvider.getDirectory());
        this.scheduledExecutorService = Executors.newScheduledThreadPool("Periodic IndexReader refreshing task for index " + this.indexName);
        this.delay = ConfigurationParseHelper.getIntValue(props, "reader.async_refresh_period_ms", 5000);
        this.scheduledExecutorService.scheduleAtFixedRate(new IndexRefreshTask(), this.delay, this.delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (this.scheduledExecutorService != null) {
            try {
                ScheduledExecutorService executorService = this.scheduledExecutorService;
                this.scheduledExecutorService = null;
                executorService.shutdown();
                executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.timedOutWaitingShutdownOfReaderProvider(this.indexName);
            }
        }
        for (IndexReader reader : this.allReaders.keySet()) {
            ReaderUsagePair usage = this.allReaders.get(reader);
            usage.close();
        }
        if (this.allReaders.size() != 0) {
            log.readersNotProperlyClosedInReaderProvider();
        }
    }

    private synchronized PerDirectoryLatestReader createReader(Directory directory) {
        PerDirectoryLatestReader reader = this.currentReaders.get(directory);
        if (reader != null) {
            return reader;
        }
        try {
            reader = new PerDirectoryLatestReader(directory);
            this.currentReaders.put(directory, reader);
            return reader;
        }
        catch (IOException e) {
            throw new SearchException("Unable to open Lucene IndexReader for IndexManager " + this.indexName, e);
        }
    }

    private final class IndexRefreshTask
    implements Runnable {
        private IndexRefreshTask() {
        }

        @Override
        public void run() {
            for (PerDirectoryLatestReader lr : PeriodicRefreshingReaderProvider.this.currentReaders.values()) {
                lr.refreshIfNeeded();
            }
        }
    }

    protected final class PerDirectoryLatestReader {
        private ReaderUsagePair current;
        private final Lock rl;
        private final Lock wl;

        public PerDirectoryLatestReader(Directory directory) throws IOException {
            ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
            this.rl = rwl.readLock();
            this.wl = rwl.writeLock();
            DirectoryReader reader = PeriodicRefreshingReaderProvider.this.readerFactory(directory);
            ReaderUsagePair initialPair = new ReaderUsagePair(reader);
            initialPair.usageCounter.set(1);
            this.wl.lock();
            this.current = initialPair;
            this.wl.unlock();
            PeriodicRefreshingReaderProvider.this.allReaders.put(reader, initialPair);
        }

        public DirectoryReader getLatestReader() {
            this.rl.lock();
            ReaderUsagePair readerUsagePair = this.current;
            readerUsagePair.usageCounter.incrementAndGet();
            this.rl.unlock();
            return readerUsagePair.reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void refreshIfNeeded() {
            DirectoryReader updatedReader;
            ReaderUsagePair readerUsagePair = this.current;
            DirectoryReader beforeUpdateReader = readerUsagePair.reader;
            try {
                updatedReader = DirectoryReader.openIfChanged(beforeUpdateReader);
            }
            catch (IOException e) {
                throw new SearchException("Unable to reopen IndexReader", e);
            }
            if (updatedReader != null) {
                ReaderUsagePair newPair = new ReaderUsagePair(updatedReader);
                PeriodicRefreshingReaderProvider.this.allReaders.put(updatedReader, newPair);
                try {
                    this.wl.lock();
                    this.current = newPair;
                    this.wl.unlock();
                }
                finally {
                    if (readerUsagePair != null) {
                        readerUsagePair.close();
                    }
                }
            }
        }
    }

    protected final class ReaderUsagePair {
        public final DirectoryReader reader;
        protected final AtomicInteger usageCounter = new AtomicInteger(2);

        ReaderUsagePair(DirectoryReader r) {
            this.reader = r;
        }

        public void close() {
            int refCount = this.usageCounter.decrementAndGet();
            if (refCount == 0) {
                ReaderUsagePair removed = PeriodicRefreshingReaderProvider.this.allReaders.remove(this.reader);
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    log.unableToCloseLuceneIndexReader(e);
                }
                assert (removed != null);
            } else if (refCount < 0) {
                throw new AssertionFailure("Closing an IndexReader for which you didn't own a lock-token, or somebody else which didn't own closed already.");
            }
        }

        public String toString() {
            return "Reader:" + this.hashCode() + " ref.count=" + this.usageCounter.get();
        }
    }
}

