/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.service.beanresolver.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.engine.service.beanresolver.spi.BeanResolver;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ReflectionBeanResolver
implements BeanResolver {
    private static final Log log = LoggerFactory.make();

    @Override
    public <T> T resolve(Class<?> classOrFactoryClass, Class<T> expectedClass) {
        Object instance;
        try {
            instance = classOrFactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw log.noPublicNoArgConstructor(classOrFactoryClass.getName());
        }
        catch (IllegalAccessException e) {
            throw log.unableToAccessClass(classOrFactoryClass.getName());
        }
        int numberOfFactoryMethodsFound = 0;
        for (Method method : classOrFactoryClass.getMethods()) {
            if (!method.isAnnotationPresent(Factory.class)) continue;
            if (numberOfFactoryMethodsFound == 1) {
                throw log.multipleFactoryMethodsInClass(classOrFactoryClass.getName());
            }
            if (method.getReturnType() == Void.TYPE) {
                throw log.factoryMethodsMustReturnAnObject(classOrFactoryClass.getName(), method.getName());
            }
            try {
                instance = method.invoke(instance, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw log.unableToAccessMethod(classOrFactoryClass.getName(), method.getName());
            }
            catch (InvocationTargetException e) {
                throw log.exceptionDuringFactoryMethodExecution(e, classOrFactoryClass.getName(), method.getName());
            }
            ++numberOfFactoryMethodsFound;
        }
        return expectedClass.cast(instance);
    }
}

