/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.nulls.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.engine.nulls.codec.impl.LuceneNullMarkerCodec;

public class LuceneStringNullMarkerCodec
extends LuceneNullMarkerCodec {
    private final BytesRef encodedToken;

    public LuceneStringNullMarkerCodec(NullMarker nullMarker) {
        super(nullMarker);
        this.encodedToken = new BytesRef((String)nullMarker.nullEncoded());
    }

    @Override
    public void encodeNullValue(String name, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addFieldToDocument(name, (String)this.nullMarker.nullEncoded(), document);
    }

    @Override
    public Query createNullMatchingQuery(String fieldName) {
        return new TermQuery(new Term(fieldName, this.encodedToken));
    }

    @Override
    public boolean representsNullValue(IndexableField field) {
        String stringValue = field.stringValue();
        return this.nullMarker.nullEncoded().equals(stringValue);
    }
}

