/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.nulls.codec.impl;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.NullMarker;
import org.hibernate.search.engine.nulls.codec.impl.LuceneNullMarkerCodec;

public class LuceneIntegerNullMarkerCodec
extends LuceneNullMarkerCodec {
    public LuceneIntegerNullMarkerCodec(NullMarker nullMarker) {
        super(nullMarker);
    }

    @Override
    public void encodeNullValue(String name, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addNumericFieldToDocument(name, this.nullMarker.nullEncoded(), document);
    }

    @Override
    public Query createNullMatchingQuery(String fieldName) {
        Integer nullEncoded = (Integer)this.nullMarker.nullEncoded();
        return NumericRangeQuery.newIntRange(fieldName, nullEncoded, nullEncoded, true, true);
    }

    @Override
    public boolean representsNullValue(IndexableField field) {
        Number numericValue = field.numericValue();
        return this.nullMarker.nullEncoded().equals(numericValue);
    }
}

