/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.bridge.util.impl;

import java.time.Duration;
import java.time.Instant;
import java.time.Year;
import java.util.Calendar;
import java.util.Date;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.spi.EncodingBridge;
import org.hibernate.search.bridge.util.impl.BridgeAdaptorUtils;
import org.hibernate.search.metadata.NumericFieldSettingsDescriptor;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class NumericFieldUtils {
    private static final Log log = LoggerFactory.make();

    private NumericFieldUtils() {
    }

    public static Query createNumericRangeQuery(String fieldName, Object from, Object to, boolean includeLower, boolean includeUpper) {
        Class<?> numericClass;
        if (from != null) {
            numericClass = from.getClass();
        } else if (to != null) {
            numericClass = to.getClass();
        } else {
            throw log.rangeQueryWithNullToAndFromValue(fieldName);
        }
        if (Double.class.isAssignableFrom(numericClass)) {
            return NumericRangeQuery.newDoubleRange(fieldName, (Double)from, (Double)to, includeLower, includeUpper);
        }
        if (Byte.class.isAssignableFrom(numericClass)) {
            return NumericRangeQuery.newIntRange(fieldName, ((Byte)from).intValue(), ((Byte)to).intValue(), includeLower, includeUpper);
        }
        if (Short.class.isAssignableFrom(numericClass)) {
            return NumericRangeQuery.newIntRange(fieldName, ((Short)from).intValue(), ((Short)to).intValue(), includeLower, includeUpper);
        }
        if (Long.class.isAssignableFrom(numericClass)) {
            return NumericRangeQuery.newLongRange(fieldName, (Long)from, (Long)to, includeLower, includeUpper);
        }
        if (Integer.class.isAssignableFrom(numericClass)) {
            return NumericRangeQuery.newIntRange(fieldName, (Integer)from, (Integer)to, includeLower, includeUpper);
        }
        if (Float.class.isAssignableFrom(numericClass)) {
            return NumericRangeQuery.newFloatRange(fieldName, (Float)from, (Float)to, includeLower, includeUpper);
        }
        if (Date.class.isAssignableFrom(numericClass)) {
            Long fromValue = from != null ? Long.valueOf(((Date)from).getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Date)to).getTime()) : null;
            return NumericRangeQuery.newLongRange(fieldName, fromValue, toValue, includeLower, includeUpper);
        }
        if (Calendar.class.isAssignableFrom(numericClass)) {
            Long fromValue = from != null ? Long.valueOf(((Calendar)from).getTime().getTime()) : null;
            Long toValue = to != null ? Long.valueOf(((Calendar)to).getTime().getTime()) : null;
            return NumericRangeQuery.newLongRange(fieldName, fromValue, toValue, includeLower, includeUpper);
        }
        if (Duration.class.isAssignableFrom(numericClass)) {
            Long fromValue = from != null ? Long.valueOf(((Duration)from).toNanos()) : null;
            Long toValue = to != null ? Long.valueOf(((Duration)to).toNanos()) : null;
            return NumericRangeQuery.newLongRange(fieldName, fromValue, toValue, includeLower, includeUpper);
        }
        if (Year.class.isAssignableFrom(numericClass)) {
            Integer fromValue = from != null ? Integer.valueOf(((Year)from).getValue()) : null;
            Integer toValue = to != null ? Integer.valueOf(((Year)to).getValue()) : null;
            return NumericRangeQuery.newIntRange(fieldName, fromValue, toValue, includeLower, includeUpper);
        }
        if (Instant.class.isAssignableFrom(numericClass)) {
            Long fromValue = from != null ? Long.valueOf(((Instant)from).toEpochMilli()) : null;
            Long toValue = to != null ? Long.valueOf(((Instant)to).toEpochMilli()) : null;
            return NumericRangeQuery.newLongRange(fieldName, fromValue, toValue, includeLower, includeUpper);
        }
        throw log.numericRangeQueryWithNonNumericToAndFromValues(fieldName);
    }

    public static Query createExactMatchQuery(String fieldName, Object value) {
        return NumericFieldUtils.createNumericRangeQuery(fieldName, value, value, true, true);
    }

    public static boolean requiresNumericRangeQuery(Object value) {
        if (value == null) {
            return false;
        }
        return value instanceof Double || value instanceof Byte || value instanceof Short || value instanceof Long || value instanceof Integer || value instanceof Float || value instanceof Date || value instanceof Calendar || value instanceof Instant || value instanceof Year || value instanceof Duration;
    }

    public static boolean isNumericFieldBridge(FieldBridge fieldBridge) {
        EncodingBridge encodingBridge = BridgeAdaptorUtils.unwrapAdaptorOnly(fieldBridge, EncodingBridge.class);
        return !NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN.equals((Object)NumericFieldUtils.getNumericEncoding(encodingBridge));
    }

    public static boolean isNumericContainerOrNumericFieldBridge(FieldBridge fieldBridge) {
        EncodingBridge encodingBridge = BridgeAdaptorUtils.unwrapAdaptorAndContainer(fieldBridge, EncodingBridge.class);
        return !NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN.equals((Object)NumericFieldUtils.getNumericEncoding(encodingBridge));
    }

    private static NumericFieldSettingsDescriptor.NumericEncodingType getNumericEncoding(EncodingBridge encodingBridge) {
        if (encodingBridge != null) {
            return encodingBridge.getEncodingType();
        }
        return NumericFieldSettingsDescriptor.NumericEncodingType.UNKNOWN;
    }
}

