/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.analysis;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.backend.impl.lucene.analysis.HibernateSearchNormalizerCheckingFilter;

public class HibernateSearchNormalizerWrapper
extends AnalyzerWrapper {
    private final Analyzer delegate;
    private final String normalizerName;

    public HibernateSearchNormalizerWrapper(Analyzer delegate, String normalizerName) {
        super(delegate.getReuseStrategy());
        this.delegate = delegate;
        this.normalizerName = normalizerName;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.delegate;
    }

    @Override
    protected Analyzer.TokenStreamComponents wrapComponents(String fieldName, Analyzer.TokenStreamComponents components) {
        HibernateSearchNormalizerCheckingFilter filter = new HibernateSearchNormalizerCheckingFilter(components.getTokenStream(), this.normalizerName);
        return new Analyzer.TokenStreamComponents(components.getTokenizer(), filter);
    }

    public String toString() {
        return "HibernateSearchNormalizerWrapper(" + this.delegate.toString() + ", normalizerName=" + this.normalizerName + ")";
    }
}

