/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import java.util.Collections;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.hibernate.search.analyzer.impl.LuceneAnalyzerReference;
import org.hibernate.search.analyzer.impl.SimpleLuceneAnalyzerReference;

public final class ScopedLuceneAnalyzer
extends AnalyzerWrapper {
    private final LuceneAnalyzerReference globalAnalyzerReference;
    private final Map<String, LuceneAnalyzerReference> scopedAnalyzerReferences;

    public ScopedLuceneAnalyzer(Analyzer globalAnalyzer) {
        this(new SimpleLuceneAnalyzerReference(globalAnalyzer), Collections.emptyMap());
    }

    ScopedLuceneAnalyzer(LuceneAnalyzerReference globalAnalyzerReference, Map<String, LuceneAnalyzerReference> scopedAnalyzerReferences) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.globalAnalyzerReference = globalAnalyzerReference;
        this.scopedAnalyzerReferences = scopedAnalyzerReferences;
    }

    public boolean isCompositeOfSameInstances(ScopedLuceneAnalyzer other) {
        if (this.toAnalyzer(this.globalAnalyzerReference) != this.toAnalyzer(other.globalAnalyzerReference)) {
            return false;
        }
        if (this.scopedAnalyzerReferences.size() != other.scopedAnalyzerReferences.size()) {
            return false;
        }
        for (String fieldname : this.scopedAnalyzerReferences.keySet()) {
            if (this.toAnalyzer(this.scopedAnalyzerReferences.get(fieldname)) == this.toAnalyzer(other.scopedAnalyzerReferences.get(fieldname))) continue;
            return false;
        }
        return true;
    }

    private Analyzer toAnalyzer(LuceneAnalyzerReference reference) {
        return reference == null ? null : reference.getAnalyzer();
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        LuceneAnalyzerReference analyzerReference = this.scopedAnalyzerReferences.get(fieldName);
        if (analyzerReference == null) {
            analyzerReference = this.globalAnalyzerReference;
        }
        return analyzerReference.getAnalyzer();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.globalAnalyzerReference);
        sb.append(",");
        sb.append(this.scopedAnalyzerReferences);
        sb.append(">");
        return sb.toString();
    }
}

