/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneCharFilterDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneNormalizerDefinitionContext;
import org.hibernate.search.analyzer.definition.LuceneTokenFilterDefinitionContext;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionRegistryBuilderImpl;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionUtils;
import org.hibernate.search.analyzer.definition.impl.LuceneCharFilterDefinitionContextImpl;
import org.hibernate.search.analyzer.definition.impl.LuceneTokenFilterDefinitionContextImpl;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.TokenFilterDef;

public class LuceneNormalizerDefinitionContextImpl
implements LuceneNormalizerDefinitionContext {
    private final LuceneAnalysisDefinitionRegistryBuilderImpl registry;
    private final String name;
    private final List<LuceneCharFilterDefinitionContextImpl> charFilters = new ArrayList<LuceneCharFilterDefinitionContextImpl>();
    private final List<LuceneTokenFilterDefinitionContextImpl> tokenFilters = new ArrayList<LuceneTokenFilterDefinitionContextImpl>();

    public LuceneNormalizerDefinitionContextImpl(LuceneAnalysisDefinitionRegistryBuilderImpl registry, String name) {
        this.registry = registry;
        this.name = name;
    }

    @Override
    public LuceneAnalyzerDefinitionContext analyzer(String name) {
        return this.registry.analyzer(name);
    }

    @Override
    public LuceneNormalizerDefinitionContext normalizer(String name) {
        return this.registry.normalizer(name);
    }

    @Override
    public LuceneCharFilterDefinitionContext charFilter(Class<? extends CharFilterFactory> factory) {
        LuceneCharFilterDefinitionContextImpl filter = new LuceneCharFilterDefinitionContextImpl(this, factory);
        this.charFilters.add(filter);
        return filter;
    }

    @Override
    public LuceneTokenFilterDefinitionContext tokenFilter(Class<? extends TokenFilterFactory> factory) {
        LuceneTokenFilterDefinitionContextImpl filter = new LuceneTokenFilterDefinitionContextImpl(this, factory);
        this.tokenFilters.add(filter);
        return filter;
    }

    public NormalizerDef build() {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(NormalizerDef.class);
        descriptor.setValue("name", this.name);
        descriptor.setValue("charFilters", LuceneAnalysisDefinitionUtils.buildAll(this.charFilters, CharFilterDef[]::new));
        descriptor.setValue("filters", LuceneAnalysisDefinitionUtils.buildAll(this.tokenFilters, TokenFilterDef[]::new));
        return (NormalizerDef)AnnotationFactory.create(descriptor);
    }
}

