/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Collections;
import java.util.Objects;
import org.apache.lucene.facet.range.LongRange;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.NumericUtils;

public final class DoubleRange
extends Range {
    final double minIncl;
    final double maxIncl;
    public final double min;
    public final double max;
    public final boolean minInclusive;
    public final boolean maxInclusive;

    public DoubleRange(String label, double minIn, boolean minInclusive, double maxIn, boolean maxInclusive) {
        super(label);
        this.min = minIn;
        this.max = maxIn;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (Double.isNaN(this.min)) {
            throw new IllegalArgumentException("min cannot be NaN");
        }
        if (!minInclusive) {
            minIn = Math.nextUp(minIn);
        }
        if (Double.isNaN(this.max)) {
            throw new IllegalArgumentException("max cannot be NaN");
        }
        if (!maxInclusive) {
            maxIn = Math.nextAfter(maxIn, Double.NEGATIVE_INFINITY);
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.minIncl = minIn;
        this.maxIncl = maxIn;
    }

    public boolean accept(double value) {
        return value >= this.minIncl && value <= this.maxIncl;
    }

    LongRange toLongRange() {
        return new LongRange(this.label, NumericUtils.doubleToSortableLong(this.minIncl), true, NumericUtils.doubleToSortableLong(this.maxIncl), true);
    }

    public String toString() {
        return "DoubleRange(" + this.minIncl + " to " + this.maxIncl + ")";
    }

    @Override
    public Query getQuery(Query fastMatchQuery, ValueSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    private static class ValueSourceQuery
    extends Query {
        private final DoubleRange range;
        private final Query fastMatchQuery;
        private final ValueSource valueSource;

        ValueSourceQuery(DoubleRange range, Query fastMatchQuery, ValueSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        @Override
        public boolean equals(Object obj) {
            if (!super.equals(obj)) {
                return false;
            }
            ValueSourceQuery other = (ValueSourceQuery)obj;
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals(other.valueSource);
        }

        @Override
        public int hashCode() {
            return 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource) + super.hashCode();
        }

        @Override
        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query fastMatchRewritten;
            if (this.getBoost() != 1.0f) {
                return super.rewrite(reader);
            }
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(reader)) != this.fastMatchQuery) {
                return new ValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(reader);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, false);
            return new ConstantScoreWeight(this){

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all(maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final FunctionValues values = ValueSourceQuery.this.valueSource.getValues(Collections.emptyMap(), context);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            return ValueSourceQuery.this.range.accept(values.doubleVal(this.approximation.docID()));
                        }

                        @Override
                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), twoPhase);
                }
            };
        }
    }
}

