/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.facet.DrillSidewaysScorer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

class DrillSidewaysQuery
extends Query {
    final Query baseQuery;
    final Collector drillDownCollector;
    final Collector[] drillSidewaysCollectors;
    final Query[] drillDownQueries;
    final boolean scoreSubDocsAtOnce;

    DrillSidewaysQuery(Query baseQuery, Collector drillDownCollector, Collector[] drillSidewaysCollectors, Query[] drillDownQueries, boolean scoreSubDocsAtOnce) {
        this.baseQuery = Objects.requireNonNull(baseQuery);
        this.drillDownCollector = drillDownCollector;
        this.drillSidewaysCollectors = drillSidewaysCollectors;
        this.drillDownQueries = drillDownQueries;
        this.scoreSubDocsAtOnce = scoreSubDocsAtOnce;
    }

    @Override
    public String toString(String field) {
        return "DrillSidewaysQuery";
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenQuery;
        if (this.getBoost() != 1.0f) {
            return super.rewrite(reader);
        }
        Query newQuery = this.baseQuery;
        while ((rewrittenQuery = newQuery.rewrite(reader)) != newQuery) {
            newQuery = rewrittenQuery;
        }
        if (newQuery == this.baseQuery) {
            return super.rewrite(reader);
        }
        return new DrillSidewaysQuery(newQuery, this.drillDownCollector, this.drillSidewaysCollectors, this.drillDownQueries, this.scoreSubDocsAtOnce);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight baseWeight = this.baseQuery.createWeight(searcher, needsScores);
        final Weight[] drillDowns = new Weight[this.drillDownQueries.length];
        for (int dim = 0; dim < this.drillDownQueries.length; ++dim) {
            drillDowns[dim] = searcher.createNormalizedWeight(this.drillDownQueries[dim], false);
        }
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return baseWeight.explain(context, doc);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return baseWeight.getValueForNormalization();
            }

            @Override
            public void normalize(float norm, float boost) {
                baseWeight.normalize(norm, boost);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
                Scorer baseScorer = baseWeight.scorer(context);
                DrillSidewaysScorer.DocsAndCost[] dims = new DrillSidewaysScorer.DocsAndCost[drillDowns.length];
                int nullCount = 0;
                for (int dim = 0; dim < dims.length; ++dim) {
                    Scorer scorer = drillDowns[dim].scorer(context);
                    if (scorer == null) {
                        ++nullCount;
                        scorer = new ConstantScoreScorer(drillDowns[dim], 0.0f, DocIdSetIterator.empty());
                    }
                    dims[dim] = new DrillSidewaysScorer.DocsAndCost(scorer, DrillSidewaysQuery.this.drillSidewaysCollectors[dim]);
                }
                if (nullCount > 1) {
                    return null;
                }
                Arrays.sort(dims, new Comparator<DrillSidewaysScorer.DocsAndCost>(){

                    @Override
                    public int compare(DrillSidewaysScorer.DocsAndCost o1, DrillSidewaysScorer.DocsAndCost o2) {
                        return Long.compare(o1.approximation.cost(), o2.approximation.cost());
                    }
                });
                if (baseScorer == null) {
                    return null;
                }
                return new DrillSidewaysScorer(context, baseScorer, DrillSidewaysQuery.this.drillDownCollector, dims, DrillSidewaysQuery.this.scoreSubDocsAtOnce);
            }
        };
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.baseQuery == null ? 0 : this.baseQuery.hashCode());
        result = 31 * result + (this.drillDownCollector == null ? 0 : this.drillDownCollector.hashCode());
        result = 31 * result + Arrays.hashCode(this.drillDownQueries);
        result = 31 * result + Arrays.hashCode(this.drillSidewaysCollectors);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DrillSidewaysQuery other = (DrillSidewaysQuery)obj;
        if (this.baseQuery == null ? other.baseQuery != null : !this.baseQuery.equals(other.baseQuery)) {
            return false;
        }
        if (this.drillDownCollector == null ? other.drillDownCollector != null : !this.drillDownCollector.equals(other.drillDownCollector)) {
            return false;
        }
        if (!Arrays.equals(this.drillDownQueries, other.drillDownQueries)) {
            return false;
        }
        return Arrays.equals(this.drillSidewaysCollectors, other.drillSidewaysCollectors);
    }
}

