/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.apache.commons.compress.archivers.zip;

import infinispan.org.apache.commons.compress.archivers.zip.GeneralPurposeBit;
import infinispan.org.apache.commons.compress.archivers.zip.Zip64ExtendedInformationExtraField;
import infinispan.org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import infinispan.org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import infinispan.org.apache.commons.compress.archivers.zip.ZipEightByteInteger;
import infinispan.org.apache.commons.compress.archivers.zip.ZipEncoding;
import infinispan.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import infinispan.org.apache.commons.compress.archivers.zip.ZipLong;
import infinispan.org.apache.commons.compress.archivers.zip.ZipShort;
import infinispan.org.apache.commons.compress.archivers.zip.ZipUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile {
    private static final int HASH_SIZE = 509;
    static final int NIBLET_MASK = 15;
    static final int BYTE_SHIFT = 8;
    private static final int POS_0 = 0;
    private static final int POS_1 = 1;
    private static final int POS_2 = 2;
    private static final int POS_3 = 3;
    private final Map<ZipArchiveEntry, OffsetEntry> entries = new LinkedHashMap<ZipArchiveEntry, OffsetEntry>(509);
    private final Map<String, ZipArchiveEntry> nameMap = new HashMap<String, ZipArchiveEntry>(509);
    private final String encoding;
    private final ZipEncoding zipEncoding;
    private final String archiveName;
    private final RandomAccessFile archive;
    private final boolean useUnicodeExtraFields;
    private boolean closed;
    private static final int CFH_LEN = 42;
    private static final long CFH_SIG = ZipLong.getValue(ZipArchiveOutputStream.CFH_SIG);
    private static final int MIN_EOCD_SIZE = 22;
    private static final int MAX_EOCD_SIZE = 65557;
    private static final int CFD_LOCATOR_OFFSET = 16;
    private static final int ZIP64_EOCDL_LENGTH = 20;
    private static final int ZIP64_EOCDL_LOCATOR_OFFSET = 8;
    private static final int ZIP64_EOCD_CFD_LOCATOR_OFFSET = 48;
    private static final long LFH_OFFSET_FOR_FILENAME_LENGTH = 26L;
    private final Comparator<ZipArchiveEntry> OFFSET_COMPARATOR = new Comparator<ZipArchiveEntry>(){

        @Override
        public int compare(ZipArchiveEntry e1, ZipArchiveEntry e2) {
            if (e1 == e2) {
                return 0;
            }
            OffsetEntry off1 = (OffsetEntry)ZipFile.this.entries.get(e1);
            OffsetEntry off2 = (OffsetEntry)ZipFile.this.entries.get(e2);
            if (off1 == null) {
                return 1;
            }
            if (off2 == null) {
                return -1;
            }
            long val = off1.headerOffset - off2.headerOffset;
            return val == 0L ? 0 : (val < 0L ? -1 : 1);
        }
    };

    public ZipFile(File f) throws IOException {
        this(f, "UTF8");
    }

    public ZipFile(String name) throws IOException {
        this(new File(name), "UTF8");
    }

    public ZipFile(String name, String encoding) throws IOException {
        this(new File(name), encoding, true);
    }

    public ZipFile(File f, String encoding) throws IOException {
        this(f, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipFile(File f, String encoding, boolean useUnicodeExtraFields) throws IOException {
        this.archiveName = f.getAbsolutePath();
        this.encoding = encoding;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(encoding);
        this.useUnicodeExtraFields = useUnicodeExtraFields;
        this.archive = new RandomAccessFile(f, "r");
        boolean success = false;
        try {
            Map<ZipArchiveEntry, NameAndComment> entriesWithoutUTF8Flag = this.populateFromCentralDirectory();
            this.resolveLocalFileHeaderData(entriesWithoutUTF8Flag);
            success = true;
        }
        finally {
            if (!success) {
                try {
                    this.closed = true;
                    this.archive.close();
                }
                catch (IOException e2) {}
            }
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void close() throws IOException {
        this.closed = true;
        this.archive.close();
    }

    public static void closeQuietly(ZipFile zipfile) {
        if (zipfile != null) {
            try {
                zipfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Enumeration<ZipArchiveEntry> getEntries() {
        return Collections.enumeration(this.entries.keySet());
    }

    public Enumeration<ZipArchiveEntry> getEntriesInPhysicalOrder() {
        ZipArchiveEntry[] allEntries = this.entries.keySet().toArray(new ZipArchiveEntry[0]);
        Arrays.sort(allEntries, this.OFFSET_COMPARATOR);
        return Collections.enumeration(Arrays.asList(allEntries));
    }

    public ZipArchiveEntry getEntry(String name) {
        return this.nameMap.get(name);
    }

    public boolean canReadEntryData(ZipArchiveEntry ze) {
        return ZipUtil.canHandleEntryData(ze);
    }

    public InputStream getInputStream(ZipArchiveEntry ze) throws IOException, ZipException {
        OffsetEntry offsetEntry = this.entries.get(ze);
        if (offsetEntry == null) {
            return null;
        }
        ZipUtil.checkRequestedFeatures(ze);
        long start = offsetEntry.dataOffset;
        BoundedInputStream bis = new BoundedInputStream(start, ze.getCompressedSize());
        switch (ze.getMethod()) {
            case 0: {
                return bis;
            }
            case 8: {
                bis.addDummy();
                final Inflater inflater = new Inflater(true);
                return new InflaterInputStream(bis, inflater){

                    public void close() throws IOException {
                        super.close();
                        inflater.end();
                    }
                };
            }
        }
        throw new ZipException("Found unsupported compression method " + ze.getMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.closed) {
                System.err.println("Cleaning up unclosed ZipFile for archive " + this.archiveName);
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private Map<ZipArchiveEntry, NameAndComment> populateFromCentralDirectory() throws IOException {
        HashMap<ZipArchiveEntry, NameAndComment> noUTF8Flag = new HashMap<ZipArchiveEntry, NameAndComment>();
        this.positionAtCentralDirectory();
        byte[] signatureBytes = new byte[4];
        this.archive.readFully(signatureBytes);
        long sig = ZipLong.getValue(signatureBytes);
        if (sig != CFH_SIG && this.startsWithLocalFileHeader()) {
            throw new IOException("central directory is empty, can't expand corrupt archive.");
        }
        while (sig == CFH_SIG) {
            this.readCentralDirectoryEntry(noUTF8Flag);
            this.archive.readFully(signatureBytes);
            sig = ZipLong.getValue(signatureBytes);
        }
        return noUTF8Flag;
    }

    private void readCentralDirectoryEntry(Map<ZipArchiveEntry, NameAndComment> noUTF8Flag) throws IOException {
        byte[] cfh = new byte[42];
        this.archive.readFully(cfh);
        int off = 0;
        ZipArchiveEntry ze = new ZipArchiveEntry();
        int versionMadeBy = ZipShort.getValue(cfh, off);
        off += 2;
        ze.setPlatform(versionMadeBy >> 8 & 0xF);
        GeneralPurposeBit gpFlag = GeneralPurposeBit.parse(cfh, off += 2);
        boolean hasUTF8Flag = gpFlag.usesUTF8ForNames();
        ZipEncoding entryEncoding = hasUTF8Flag ? ZipEncodingHelper.UTF8_ZIP_ENCODING : this.zipEncoding;
        ze.setGeneralPurposeBit(gpFlag);
        ze.setMethod(ZipShort.getValue(cfh, off += 2));
        long time = ZipUtil.dosToJavaTime(ZipLong.getValue(cfh, off += 2));
        ze.setTime(time);
        ze.setCrc(ZipLong.getValue(cfh, off += 4));
        ze.setCompressedSize(ZipLong.getValue(cfh, off += 4));
        ze.setSize(ZipLong.getValue(cfh, off += 4));
        int fileNameLen = ZipShort.getValue(cfh, off += 4);
        int extraLen = ZipShort.getValue(cfh, off += 2);
        int commentLen = ZipShort.getValue(cfh, off += 2);
        int diskStart = ZipShort.getValue(cfh, off += 2);
        ze.setInternalAttributes(ZipShort.getValue(cfh, off += 2));
        ze.setExternalAttributes(ZipLong.getValue(cfh, off += 2));
        byte[] fileName = new byte[fileNameLen];
        this.archive.readFully(fileName);
        ze.setName(entryEncoding.decode(fileName), fileName);
        OffsetEntry offset = new OffsetEntry();
        offset.headerOffset = ZipLong.getValue(cfh, off += 4);
        this.entries.put(ze, offset);
        this.nameMap.put(ze.getName(), ze);
        byte[] cdExtraData = new byte[extraLen];
        this.archive.readFully(cdExtraData);
        ze.setCentralDirectoryExtra(cdExtraData);
        this.setSizesAndOffsetFromZip64Extra(ze, offset, diskStart);
        byte[] comment = new byte[commentLen];
        this.archive.readFully(comment);
        ze.setComment(entryEncoding.decode(comment));
        if (!hasUTF8Flag && this.useUnicodeExtraFields) {
            noUTF8Flag.put(ze, new NameAndComment(fileName, comment));
        }
    }

    private void setSizesAndOffsetFromZip64Extra(ZipArchiveEntry ze, OffsetEntry offset, int diskStart) throws IOException {
        Zip64ExtendedInformationExtraField z64 = (Zip64ExtendedInformationExtraField)ze.getExtraField(Zip64ExtendedInformationExtraField.HEADER_ID);
        if (z64 != null) {
            boolean hasUncompressedSize = ze.getSize() == 0xFFFFFFFFL;
            boolean hasCompressedSize = ze.getCompressedSize() == 0xFFFFFFFFL;
            boolean hasRelativeHeaderOffset = offset.headerOffset == 0xFFFFFFFFL;
            z64.reparseCentralDirectoryData(hasUncompressedSize, hasCompressedSize, hasRelativeHeaderOffset, diskStart == 65535);
            if (hasUncompressedSize) {
                ze.setSize(z64.getSize().getLongValue());
            } else if (hasCompressedSize) {
                z64.setSize(new ZipEightByteInteger(ze.getSize()));
            }
            if (hasCompressedSize) {
                ze.setCompressedSize(z64.getCompressedSize().getLongValue());
            } else if (hasUncompressedSize) {
                z64.setCompressedSize(new ZipEightByteInteger(ze.getCompressedSize()));
            }
            if (hasRelativeHeaderOffset) {
                offset.headerOffset = z64.getRelativeHeaderOffset().getLongValue();
            }
        }
    }

    private void positionAtCentralDirectory() throws IOException {
        boolean found = this.tryToLocateSignature(42L, 65577L, ZipArchiveOutputStream.ZIP64_EOCD_LOC_SIG);
        if (!found) {
            this.positionAtCentralDirectory32();
        } else {
            this.positionAtCentralDirectory64();
        }
    }

    private void positionAtCentralDirectory64() throws IOException {
        this.skipBytes(8);
        byte[] zip64EocdOffset = new byte[8];
        this.archive.readFully(zip64EocdOffset);
        this.archive.seek(ZipEightByteInteger.getLongValue(zip64EocdOffset));
        byte[] sig = new byte[4];
        this.archive.readFully(sig);
        if (sig[0] != ZipArchiveOutputStream.ZIP64_EOCD_SIG[0] || sig[1] != ZipArchiveOutputStream.ZIP64_EOCD_SIG[1] || sig[2] != ZipArchiveOutputStream.ZIP64_EOCD_SIG[2] || sig[3] != ZipArchiveOutputStream.ZIP64_EOCD_SIG[3]) {
            throw new ZipException("archive's ZIP64 end of central directory locator is corrupt.");
        }
        this.skipBytes(44);
        byte[] cfdOffset = new byte[8];
        this.archive.readFully(cfdOffset);
        this.archive.seek(ZipEightByteInteger.getLongValue(cfdOffset));
    }

    private void positionAtCentralDirectory32() throws IOException {
        boolean found = this.tryToLocateSignature(22L, 65557L, ZipArchiveOutputStream.EOCD_SIG);
        if (!found) {
            throw new ZipException("archive is not a ZIP archive");
        }
        this.skipBytes(16);
        byte[] cfdOffset = new byte[4];
        this.archive.readFully(cfdOffset);
        this.archive.seek(ZipLong.getValue(cfdOffset));
    }

    private boolean tryToLocateSignature(long minDistanceFromEnd, long maxDistanceFromEnd, byte[] sig) throws IOException {
        long off;
        boolean found = false;
        long stopSearching = Math.max(0L, this.archive.length() - maxDistanceFromEnd);
        if (off >= 0L) {
            for (off = this.archive.length() - minDistanceFromEnd; off >= stopSearching; --off) {
                this.archive.seek(off);
                int curr = this.archive.read();
                if (curr == -1) break;
                if (curr != sig[0] || (curr = this.archive.read()) != sig[1] || (curr = this.archive.read()) != sig[2] || (curr = this.archive.read()) != sig[3]) continue;
                found = true;
                break;
            }
        }
        if (found) {
            this.archive.seek(off);
        }
        return found;
    }

    private void skipBytes(int count) throws IOException {
        int skippedNow;
        for (int totalSkipped = 0; totalSkipped < count; totalSkipped += skippedNow) {
            skippedNow = this.archive.skipBytes(count - totalSkipped);
            if (skippedNow > 0) continue;
            throw new EOFException();
        }
    }

    private void resolveLocalFileHeaderData(Map<ZipArchiveEntry, NameAndComment> entriesWithoutUTF8Flag) throws IOException {
        LinkedHashMap<ZipArchiveEntry, OffsetEntry> origMap = new LinkedHashMap<ZipArchiveEntry, OffsetEntry>(this.entries);
        this.entries.clear();
        for (Map.Entry ent : origMap.entrySet()) {
            int skipped;
            ZipArchiveEntry ze = (ZipArchiveEntry)ent.getKey();
            OffsetEntry offsetEntry = (OffsetEntry)ent.getValue();
            long offset = offsetEntry.headerOffset;
            this.archive.seek(offset + 26L);
            byte[] b = new byte[2];
            this.archive.readFully(b);
            int fileNameLen = ZipShort.getValue(b);
            this.archive.readFully(b);
            int extraFieldLen = ZipShort.getValue(b);
            for (int lenToSkip = fileNameLen; lenToSkip > 0; lenToSkip -= skipped) {
                skipped = this.archive.skipBytes(lenToSkip);
                if (skipped > 0) continue;
                throw new IOException("failed to skip file name in local file header");
            }
            byte[] localExtraData = new byte[extraFieldLen];
            this.archive.readFully(localExtraData);
            ze.setExtra(localExtraData);
            offsetEntry.dataOffset = offset + 26L + 2L + 2L + (long)fileNameLen + (long)extraFieldLen;
            if (entriesWithoutUTF8Flag.containsKey(ze)) {
                String orig = ze.getName();
                NameAndComment nc = entriesWithoutUTF8Flag.get(ze);
                ZipUtil.setNameAndCommentFromExtraFields(ze, nc.name, nc.comment);
                if (!orig.equals(ze.getName())) {
                    this.nameMap.remove(orig);
                    this.nameMap.put(ze.getName(), ze);
                }
            }
            this.entries.put(ze, offsetEntry);
        }
    }

    private boolean startsWithLocalFileHeader() throws IOException {
        this.archive.seek(0L);
        byte[] start = new byte[4];
        this.archive.readFully(start);
        for (int i = 0; i < start.length; ++i) {
            if (start[i] == ZipArchiveOutputStream.LFH_SIG[i]) continue;
            return false;
        }
        return true;
    }

    private static final class NameAndComment {
        private final byte[] name;
        private final byte[] comment;

        private NameAndComment(byte[] name, byte[] comment) {
            this.name = name;
            this.comment = comment;
        }
    }

    private class BoundedInputStream
    extends InputStream {
        private long remaining;
        private long loc;
        private boolean addDummyByte = false;

        BoundedInputStream(long start, long remaining) {
            this.remaining = remaining;
            this.loc = start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read() throws IOException {
            if (this.remaining-- <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    return 0;
                }
                return -1;
            }
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc++);
                return ZipFile.this.archive.read();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] b, int off, int len) throws IOException {
            if (this.remaining <= 0L) {
                if (this.addDummyByte) {
                    this.addDummyByte = false;
                    b[off] = 0;
                    return 1;
                }
                return -1;
            }
            if (len <= 0) {
                return 0;
            }
            if ((long)len > this.remaining) {
                len = (int)this.remaining;
            }
            int ret = -1;
            RandomAccessFile randomAccessFile = ZipFile.this.archive;
            synchronized (randomAccessFile) {
                ZipFile.this.archive.seek(this.loc);
                ret = ZipFile.this.archive.read(b, off, len);
            }
            if (ret > 0) {
                this.loc += (long)ret;
                this.remaining -= (long)ret;
            }
            return ret;
        }

        void addDummy() {
            this.addDummyByte = true;
        }
    }

    private static final class OffsetEntry {
        private long headerOffset = -1L;
        private long dataOffset = -1L;

        private OffsetEntry() {
        }
    }
}

