/*
 * Decompiled with CFR 0.152.
 */
package org.incava.diff;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.incava.diff.Difference;
import org.incava.diff.LCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Differ<ObjectType, DiffType extends Difference> {
    private final List<ObjectType> from;
    private final List<ObjectType> to;
    private final List<DiffType> diffs;
    private Integer delStart = null;
    private Integer delEnd = null;
    private Integer addStart = null;
    private Integer addEnd = null;
    private final Comparator<ObjectType> comparator;

    public Differ(ObjectType[] from, ObjectType[] to, Comparator<ObjectType> comp) {
        this(Arrays.asList(from), Arrays.asList(to), comp);
    }

    public Differ(ObjectType[] from, ObjectType[] to) {
        this(from, to, null);
    }

    public Differ(List<ObjectType> from, List<ObjectType> to) {
        this(from, to, null);
    }

    public Differ(List<ObjectType> from, List<ObjectType> to, Comparator<ObjectType> comp) {
        this.from = from;
        this.to = to;
        this.comparator = comp;
        this.diffs = new ArrayList<DiffType>();
    }

    public List<DiffType> execute() {
        this.traverseSequences();
        this.addPending();
        return this.diffs;
    }

    @Deprecated
    public List<DiffType> diff() {
        return this.execute();
    }

    public abstract DiffType createDifference(Integer var1, Integer var2, Integer var3, Integer var4);

    protected void addPending() {
        if (this.delStart != null) {
            this.diffs.add(this.createDifference(this.delStart, this.delEnd, this.addStart, this.addEnd));
            this.delStart = null;
            this.delEnd = null;
            this.addStart = null;
            this.addEnd = null;
        }
    }

    protected void traverseSequences() {
        int fromIdx;
        LCS<ObjectType> lcs = new LCS<ObjectType>(this.from, this.to, this.comparator);
        List<Integer> matches = lcs.getMatches();
        int toIdx = 0;
        int lastMatch = matches.size() - 1;
        for (fromIdx = 0; fromIdx <= lastMatch; ++fromIdx) {
            Integer toElement = matches.get(fromIdx);
            if (toElement == null) {
                this.onFromNotTo(fromIdx, toIdx);
                continue;
            }
            while (toIdx < toElement) {
                this.onToNotFrom(fromIdx, toIdx++);
            }
            this.onMatch(fromIdx, toIdx++);
        }
        this.traverseEndOfSequences(fromIdx, toIdx);
    }

    protected void traverseEndOfSequences(int fromIdx, int toIdx) {
        int lastFrom = this.from.size() - 1;
        int lastTo = this.to.size() - 1;
        while (fromIdx <= lastFrom || toIdx <= lastTo) {
            if (fromIdx == lastFrom + 1 && toIdx <= lastTo) {
                while (toIdx <= lastTo) {
                    this.onToNotFrom(fromIdx, toIdx++);
                }
            }
            if (toIdx == lastTo + 1 && fromIdx <= lastFrom) {
                while (fromIdx <= lastFrom) {
                    this.onFromNotTo(fromIdx++, toIdx);
                }
            }
            if (fromIdx <= lastFrom) {
                this.onFromNotTo(fromIdx++, toIdx);
            }
            if (toIdx > lastTo) continue;
            this.onToNotFrom(fromIdx, toIdx++);
        }
    }

    protected void onFromNotTo(int fromIdx, int toIdx) {
        if (this.delStart == null) {
            this.setIndices(fromIdx, fromIdx, toIdx, Difference.NONE);
        } else {
            this.delStart = Math.min(fromIdx, this.delStart);
            this.delEnd = Math.max(fromIdx, this.delEnd);
        }
    }

    protected void onToNotFrom(int fromIdx, int toIdx) {
        if (this.delStart == null) {
            this.setIndices(fromIdx, Difference.NONE, toIdx, toIdx);
        } else {
            this.addStart = Math.min(toIdx, this.addStart);
            this.addEnd = Math.max(toIdx, this.addEnd);
        }
    }

    private void setIndices(int delSt, int delEn, int addSt, int addEn) {
        this.delStart = delSt;
        this.delEnd = delEn;
        this.addStart = addSt;
        this.addEnd = addEn;
    }

    protected void onMatch(int fromIdx, int toIdx) {
        this.addPending();
    }
}

