/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.server.middleware.authentication;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.http4s.server.middleware.authentication.Nonce;
import org.http4s.server.middleware.authentication.Nonce$;
import org.http4s.server.middleware.authentication.NonceKeeper$BadNCReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$OKReply$;
import org.http4s.server.middleware.authentication.NonceKeeper$StaleReply$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015wAB\u001a5\u0011\u0003!dH\u0002\u0004Ai!\u0005A'\u0011\u0005\u0006\u0011\u0006!\tA\u0013\u0004\u0006\u0017\u0006\t\t\u0003\u0014\u0005\u0006\u0011\u000e!\t!T\u0004\b\u0003\u0007\n\u0001\u0012QA\u001d\r\u001d\t\u0019$\u0001EA\u0003kAa\u0001\u0013\u0004\u0005\u0002\u0005]\u0002b\u00023\u0007\u0003\u0003%\t%\u001a\u0005\b]\u001a\t\t\u0011\"\u0001p\u0011!\u0019h!!A\u0005\u0002\u0005m\u0002b\u0002>\u0007\u0003\u0003%\te\u001f\u0005\n\u0003\u000b1\u0011\u0011!C\u0001\u0003\u007fA\u0011\"!\u0005\u0007\u0003\u0003%\t%a\u0005\t\u0013\u0005Ua!!A\u0005B\u0005]\u0001\"CA\r\r\u0005\u0005I\u0011BA\u000e\u000f\u001d\t)%\u0001EA\u0003S1q!a\t\u0002\u0011\u0003\u000b)\u0003\u0003\u0004I#\u0011\u0005\u0011q\u0005\u0005\bIF\t\t\u0011\"\u0011f\u0011\u001dq\u0017#!A\u0005\u0002=D\u0001b]\t\u0002\u0002\u0013\u0005\u00111\u0006\u0005\buF\t\t\u0011\"\u0011|\u0011%\t)!EA\u0001\n\u0003\ty\u0003C\u0005\u0002\u0012E\t\t\u0011\"\u0011\u0002\u0014!I\u0011QC\t\u0002\u0002\u0013\u0005\u0013q\u0003\u0005\n\u00033\t\u0012\u0011!C\u0005\u000379a!a\u0012\u0002\u0011\u0003\u001bg!B)\u0002\u0011\u0003\u0013\u0006\"\u0002%\u001d\t\u0003\u0011\u0007b\u00023\u001d\u0003\u0003%\t%\u001a\u0005\b]r\t\t\u0011\"\u0001p\u0011\u001d\u0019H$!A\u0005\u0002QDqA\u001f\u000f\u0002\u0002\u0013\u00053\u0010C\u0005\u0002\u0006q\t\t\u0011\"\u0001\u0002\b!I\u0011\u0011\u0003\u000f\u0002\u0002\u0013\u0005\u00131\u0003\u0005\n\u0003+a\u0012\u0011!C!\u0003/A\u0011\"!\u0007\u001d\u0003\u0003%I!a\u0007\u0007\r\u0001#\u0004\u0001NA%\u0011)\tYE\nB\u0001B\u0003%\u0011Q\n\u0005\u000b\u0003'2#\u0011!Q\u0001\n\u00055\u0003\"CA+M\t\u0005\t\u0015!\u0003q\u0011\u0019Ae\u0005\"\u0001\u0002X!I\u0011\u0011\r\u0014C\u0002\u0013%\u00111\r\u0005\t\u0003\u000b3\u0003\u0015!\u0003\u0002f!I\u0011q\u0011\u0014A\u0002\u0013%\u0011\u0011\u0012\u0005\n\u0003\u00173\u0003\u0019!C\u0005\u0003\u001bC\u0001\"a&'A\u0003&\u0011Q\n\u0005\b\u000333C\u0011BAN\u0011\u001d\tiJ\nC\u0001\u0003?Cq!!)'\t\u0003\t\u0019+A\u0006O_:\u001cWmS3fa\u0016\u0014(BA\u001b7\u00039\tW\u000f\u001e5f]RL7-\u0019;j_:T!a\u000e\u001d\u0002\u00155LG\r\u001a7fo\u0006\u0014XM\u0003\u0002:u\u000511/\u001a:wKJT!a\u000f\u001f\u0002\r!$H\u000f\u001d\u001bt\u0015\u0005i\u0014aA8sOB\u0011q(A\u0007\u0002i\tYaj\u001c8dK.+W\r]3s'\t\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EI\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\taHA\u0003SKBd\u0017p\u0005\u0002\u0004\u0005R\ta\n\u0005\u0002P\u00075\t\u0011!\u000b\u0003\u00049E1!A\u0003\"bI:\u001b%+\u001a9msN!ADT*W!\t\u0019E+\u0003\u0002V\t\n9\u0001K]8ek\u000e$\bCA,`\u001d\tAVL\u0004\u0002Z96\t!L\u0003\u0002\\\u0013\u00061AH]8pizJ\u0011!R\u0005\u0003=\u0012\u000bq\u0001]1dW\u0006<W-\u0003\u0002aC\na1+\u001a:jC2L'0\u00192mK*\u0011a\f\u0012\u000b\u0002GB\u0011q\nH\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0003\u0019\u0004\"a\u001a7\u000e\u0003!T!!\u001b6\u0002\t1\fgn\u001a\u0006\u0002W\u0006!!.\u0019<b\u0013\ti\u0007N\u0001\u0004TiJLgnZ\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0002aB\u00111)]\u0005\u0003e\u0012\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$\"!\u001e=\u0011\u0005\r3\u0018BA<E\u0005\r\te.\u001f\u0005\bs\u0002\n\t\u00111\u0001q\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\tA\u0010\u0005\u0003~\u0003\u0003)X\"\u0001@\u000b\u0005}$\u0015AC2pY2,7\r^5p]&\u0019\u00111\u0001@\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u0013\ty\u0001E\u0002D\u0003\u0017I1!!\u0004E\u0005\u001d\u0011un\u001c7fC:Dq!\u001f\u0012\u0002\u0002\u0003\u0007Q/\u0001\u0005iCND7i\u001c3f)\u0005\u0001\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0019\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!!\b\u0011\u0007\u001d\fy\"C\u0002\u0002\"!\u0014aa\u00142kK\u000e$(aB(L%\u0016\u0004H._\n\u0005#9\u001bf\u000b\u0006\u0002\u0002*A\u0011q*\u0005\u000b\u0004k\u00065\u0002bB=\u0016\u0003\u0003\u0005\r\u0001\u001d\u000b\u0005\u0003\u0013\t\t\u0004C\u0004z/\u0005\u0005\t\u0019A;\u0003\u0015M#\u0018\r\\3SKBd\u0017p\u0005\u0003\u0007\u001dN3FCAA\u001d!\tye\u0001F\u0002v\u0003{Aq!\u001f\u0006\u0002\u0002\u0003\u0007\u0001\u000f\u0006\u0003\u0002\n\u0005\u0005\u0003bB=\r\u0003\u0003\u0005\r!^\u0001\u000b'R\fG.\u001a*fa2L\u0018aB(L%\u0016\u0004H._\u0001\u000b\u0005\u0006$gj\u0011*fa2L8C\u0001\u0014C\u00031\u0019H/\u00197f)&lWm\\;u!\r\u0019\u0015qJ\u0005\u0004\u0003#\"%\u0001\u0002'p]\u001e\fAC\\8oG\u0016\u001cE.Z1okBLe\u000e^3sm\u0006d\u0017\u0001\u00022jiN$\u0002\"!\u0017\u0002\\\u0005u\u0013q\f\t\u0003\u007f\u0019Bq!a\u0013+\u0001\u0004\ti\u0005C\u0004\u0002T)\u0002\r!!\u0014\t\r\u0005U#\u00061\u0001q\u0003\u0019qwN\\2fgV\u0011\u0011Q\r\t\t\u0003O\ni'!\u001d\u0002\u00005\u0011\u0011\u0011\u000e\u0006\u0004\u0003WR\u0017\u0001B;uS2LA!a\u001c\u0002j\tiA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004B!a\u001d\u0002|9!\u0011QOA<!\tIF)C\u0002\u0002z\u0011\u000ba\u0001\u0015:fI\u00164\u0017bA7\u0002~)\u0019\u0011\u0011\u0010#\u0011\u0007}\n\t)C\u0002\u0002\u0004R\u0012QAT8oG\u0016\fqA\\8oG\u0016\u001c\b%A\u0006mCN$8\t\\3b]V\u0004XCAA'\u0003=a\u0017m\u001d;DY\u0016\fg.\u001e9`I\u0015\fH\u0003BAH\u0003+\u00032aQAI\u0013\r\t\u0019\n\u0012\u0002\u0005+:LG\u000f\u0003\u0005z]\u0005\u0005\t\u0019AA'\u00031a\u0017m\u001d;DY\u0016\fg.\u001e9!\u0003)\u0019\u0007.Z2l'R\fG.\u001a\u000b\u0003\u0003\u001f\u000b\u0001B\\3x\u001d>t7-\u001a\u000b\u0003\u0003c\nAB]3dK&4XMT8oG\u0016$b!!*\u0002*\u00065\u0006cAAT\u00079\u0011q\b\u0001\u0005\b\u0003W\u0013\u0004\u0019AA9\u0003\u0011!\u0017\r^1\t\r\u0005=&\u00071\u0001q\u0003\tq7\rK\u0006'\u0003g\u000bI,a/\u0002@\u0006\u0005\u0007cA\"\u00026&\u0019\u0011q\u0017#\u0003\u0015\u0011,\u0007O]3dCR,G-A\u0004nKN\u001c\u0018mZ3\"\u0005\u0005u\u0016!I*jI\u0016lSM\u001a4fGRLgn\u001a\u0018!+N,\u0007ET8oG\u0016\\U-\u001a9fe\u001as\u0013!B:j]\u000e,\u0017EAAb\u0003\u001d\u0001dFM\u001a/cI\u0002")
public class NonceKeeper {
    private final long staleTimeout;
    private final long nonceCleanupInterval;
    private final int bits;
    private final LinkedHashMap<String, Nonce> nonces;
    private long lastCleanup;

    private LinkedHashMap<String, Nonce> nonces() {
        return this.nonces;
    }

    private long lastCleanup() {
        return this.lastCleanup;
    }

    private void lastCleanup_$eq(long x$1) {
        this.lastCleanup = x$1;
    }

    private void checkStale() {
        long d = System.currentTimeMillis();
        if (d - this.lastCleanup() > this.nonceCleanupInterval) {
            this.lastCleanup_$eq(d);
            Iterator<Nonce> it = this.nonces().values().iterator();
            this.dropStale$1(it, d);
            return;
        }
    }

    public String newNonce() {
        Nonce n = null;
        LinkedHashMap<String, Nonce> linkedHashMap = this.nonces();
        synchronized (linkedHashMap) {
            this.checkStale();
            n = Nonce$.MODULE$.gen(this.bits);
            while (this.nonces().get(n.data()) != null) {
                n = Nonce$.MODULE$.gen(this.bits);
            }
            this.nonces().put(n.data(), n);
        }
        return n.data();
    }

    public Reply receiveNonce(String data, int nc) {
        NonceKeeper$StaleReply$ nonceKeeper$StaleReply$;
        LinkedHashMap<String, Nonce> linkedHashMap = this.nonces();
        synchronized (linkedHashMap) {
            Reply reply;
            this.checkStale();
            Nonce nonce = this.nonces().get(data);
            if (nonce == null) {
                reply = NonceKeeper$StaleReply$.MODULE$;
            } else if (nonce != null) {
                Nonce nonce2 = nonce;
                if (nc > nonce2.nc()) {
                    nonce2.nc_$eq(nonce2.nc() + 1);
                    reply = NonceKeeper$OKReply$.MODULE$;
                } else {
                    reply = NonceKeeper$BadNCReply$.MODULE$;
                }
            } else {
                throw new MatchError((Object)nonce);
            }
            nonceKeeper$StaleReply$ = reply;
        }
        return nonceKeeper$StaleReply$;
    }

    private final void dropStale$1(Iterator it$1, long d$1) {
        while (it$1.hasNext() && this.staleTimeout > d$1 - ((Nonce)it$1.next()).created().getTime()) {
            it$1.remove();
        }
    }

    public NonceKeeper(long staleTimeout, long nonceCleanupInterval, int bits) {
        this.staleTimeout = staleTimeout;
        this.nonceCleanupInterval = nonceCleanupInterval;
        this.bits = bits;
        Predef$.MODULE$.require(bits > 0, (Function0 & Serializable)() -> "Please supply a positive integer for bits.");
        this.nonces = new LinkedHashMap();
        this.lastCleanup = System.currentTimeMillis();
    }

    public static abstract class Reply {
    }
}

