/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server.accesstoken;

import com.natpryce.Failure;
import com.natpryce.Result;
import com.natpryce.Success;
import java.time.Clock;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Body;
import org.http4k.core.HttpMessage;
import org.http4k.core.Request;
import org.http4k.lens.BiDiBodyLens;
import org.http4k.lens.BiDiLens;
import org.http4k.lens.FormField;
import org.http4k.lens.Lens;
import org.http4k.lens.LensSpec;
import org.http4k.lens.Validator;
import org.http4k.lens.WebForm;
import org.http4k.lens.WebFormKt;
import org.http4k.security.AccessTokenDetails;
import org.http4k.security.oauth.server.AccessTokenError;
import org.http4k.security.oauth.server.AccessTokens;
import org.http4k.security.oauth.server.AuthorizationCodes;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.IdTokens;
import org.http4k.security.oauth.server.OAuthServerKt;
import org.http4k.security.oauth.server.TokenRequest;
import org.http4k.security.oauth.server.UnsupportedGrantType;
import org.http4k.security.oauth.server.accesstoken.AccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.AccessTokenRequestAuthentication;
import org.http4k.security.oauth.server.accesstoken.AuthorizationCodeAccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.ClientCredentialsAccessTokenGenerator;
import org.http4k.security.oauth.server.accesstoken.GenerateAccessTokenForGrantType$WhenMappings;
import org.http4k.security.oauth.server.accesstoken.GrantType;
import org.http4k.security.oauth.server.accesstoken.GrantTypesConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u00122\u0006\u0010\u0015\u001a\u00020\u0016J(\u0010\u0017\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001c\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001b0\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u001f\u001a\u00020\u0019*\u00020\u001dH\u0002R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/GenerateAccessTokenForGrantType;", "", "authorizationCodes", "Lorg/http4k/security/oauth/server/AuthorizationCodes;", "accessTokens", "Lorg/http4k/security/oauth/server/AccessTokens;", "clock", "Ljava/time/Clock;", "idTokens", "Lorg/http4k/security/oauth/server/IdTokens;", "grantTypes", "Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;", "(Lorg/http4k/security/oauth/server/AuthorizationCodes;Lorg/http4k/security/oauth/server/AccessTokens;Ljava/time/Clock;Lorg/http4k/security/oauth/server/IdTokens;Lorg/http4k/security/oauth/server/accesstoken/GrantTypesConfiguration;)V", "authorizationCode", "Lorg/http4k/security/oauth/server/accesstoken/AuthorizationCodeAccessTokenGenerator;", "clientCredentials", "Lorg/http4k/security/oauth/server/accesstoken/ClientCredentialsAccessTokenGenerator;", "generate", "Lcom/natpryce/Result;", "Lorg/http4k/security/AccessTokenDetails;", "Lorg/http4k/security/oauth/server/AccessTokenError;", "request", "Lorg/http4k/core/Request;", "resolveGrantTypeFromConfiguration", "Lkotlin/Pair;", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenGenerator;", "Lorg/http4k/security/oauth/server/accesstoken/AccessTokenRequestAuthentication;", "Lorg/http4k/security/oauth/server/UnsupportedGrantType;", "grantType", "Lorg/http4k/security/oauth/server/accesstoken/GrantType;", "resolveGrantTypeFromRequest", "generator", "Companion", "http4k-security-oauth"})
public final class GenerateAccessTokenForGrantType {
    private final AuthorizationCodeAccessTokenGenerator authorizationCode;
    private final ClientCredentialsAccessTokenGenerator clientCredentials;
    private final GrantTypesConfiguration grantTypes;
    @NotNull
    private static final BiDiLens<WebForm, String> grantType;
    @NotNull
    private static final BiDiBodyLens<WebForm> grantTypeForm;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final Result<AccessTokenDetails, AccessTokenError> generate(@NotNull Request request2) {
        Object object;
        Result<GrantType, UnsupportedGrantType> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Result<GrantType, UnsupportedGrantType> result = $receiver$iv = this.resolveGrantTypeFromRequest(request2);
        if (!(result instanceof Success)) {
            if (!(result instanceof Failure)) throw new NoWhenBranchMatchedException();
            Failure it = (Failure)$receiver$iv;
            return (Result)it;
        }
        GrantType grantType = (GrantType)((Object)((Success)$receiver$iv).getValue());
        $receiver$iv = this.resolveGrantTypeFromConfiguration(grantType);
        result = $receiver$iv;
        if (result instanceof Success) {
            void $receiver$iv2;
            Pair $dstr$generator$authenticator = (Pair)((Success)$receiver$iv).getValue();
            boolean bl = false;
            AccessTokenGenerator generator = (AccessTokenGenerator)$dstr$generator$authenticator.component1();
            AccessTokenRequestAuthentication authenticator = (AccessTokenRequestAuthentication)$dstr$generator$authenticator.component2();
            Result<Triple<Request, ClientId, TokenRequest>, AccessTokenError> result2 = authenticator.validateCredentials(request2, OAuthServerKt.tokenRequest(request2, grantType));
            void var10_12 = $receiver$iv2;
            if (var10_12 instanceof Success) {
                Triple $dstr$request$clientId$tokenRequest = (Triple)((Success)$receiver$iv2).getValue();
                boolean bl2 = false;
                Request request3 = (Request)$dstr$request$clientId$tokenRequest.component1();
                ClientId clientId = (ClientId)$dstr$request$clientId$tokenRequest.component2();
                TokenRequest tokenRequest = (TokenRequest)$dstr$request$clientId$tokenRequest.component3();
                object = generator.generate(request3, clientId, tokenRequest);
                return object;
            } else {
                if (!(var10_12 instanceof Failure)) throw new NoWhenBranchMatchedException();
                object = $receiver$iv2;
            }
            return object;
        } else {
            if (!(result instanceof Failure)) throw new NoWhenBranchMatchedException();
            object = $receiver$iv;
        }
        return object;
    }

    private final Result<Pair<AccessTokenGenerator, AccessTokenRequestAuthentication>, UnsupportedGrantType> resolveGrantTypeFromConfiguration(GrantType grantType) {
        Result result;
        AccessTokenRequestAuthentication accessTokenRequestAuthentication = this.grantTypes.getSupportedGrantTypes().get((Object)grantType);
        if (accessTokenRequestAuthentication != null) {
            AccessTokenRequestAuthentication accessTokenRequestAuthentication2 = accessTokenRequestAuthentication;
            boolean bl = false;
            boolean bl2 = false;
            AccessTokenRequestAuthentication it = accessTokenRequestAuthentication2;
            boolean bl3 = false;
            result = (Result)new Success((Object)TuplesKt.to((Object)this.generator(grantType), (Object)it));
        } else {
            result = (Result)new Failure((Object)new UnsupportedGrantType(grantType.getRfcValue()));
        }
        return result;
    }

    private final Result<GrantType, UnsupportedGrantType> resolveGrantTypeFromRequest(Request request2) {
        Object object = grantTypeForm.invoke((HttpMessage)request2);
        boolean bl = false;
        boolean bl2 = false;
        WebForm form = (WebForm)object;
        boolean bl3 = false;
        String grantType = (String)GenerateAccessTokenForGrantType.grantType.invoke((Object)form);
        return Intrinsics.areEqual((Object)grantType, (Object)GrantType.AuthorizationCode.getRfcValue()) ? (Result)new Success((Object)GrantType.AuthorizationCode) : (Intrinsics.areEqual((Object)grantType, (Object)GrantType.ClientCredentials.getRfcValue()) ? (Result)new Success((Object)GrantType.ClientCredentials) : (Result)new Failure((Object)new UnsupportedGrantType(grantType)));
    }

    private final AccessTokenGenerator generator(@NotNull GrantType $this$generator) {
        AccessTokenGenerator accessTokenGenerator;
        switch (GenerateAccessTokenForGrantType$WhenMappings.$EnumSwitchMapping$0[$this$generator.ordinal()]) {
            case 1: {
                accessTokenGenerator = this.authorizationCode;
                break;
            }
            case 2: {
                accessTokenGenerator = this.clientCredentials;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return accessTokenGenerator;
    }

    public GenerateAccessTokenForGrantType(@NotNull AuthorizationCodes authorizationCodes, @NotNull AccessTokens accessTokens, @NotNull Clock clock, @NotNull IdTokens idTokens, @NotNull GrantTypesConfiguration grantTypes) {
        Intrinsics.checkParameterIsNotNull((Object)authorizationCodes, (String)"authorizationCodes");
        Intrinsics.checkParameterIsNotNull((Object)accessTokens, (String)"accessTokens");
        Intrinsics.checkParameterIsNotNull((Object)clock, (String)"clock");
        Intrinsics.checkParameterIsNotNull((Object)idTokens, (String)"idTokens");
        Intrinsics.checkParameterIsNotNull((Object)grantTypes, (String)"grantTypes");
        this.grantTypes = grantTypes;
        this.authorizationCode = new AuthorizationCodeAccessTokenGenerator(authorizationCodes, accessTokens, clock, idTokens);
        this.clientCredentials = new ClientCredentialsAccessTokenGenerator(accessTokens);
    }

    static {
        Companion = new Companion(null);
        grantType = (BiDiLens)LensSpec.required$default((LensSpec)FormField.INSTANCE, (String)"grant_type", null, (int)2, null);
        grantTypeForm = WebFormKt.webForm((Body.Companion)Body.Companion, (Validator)Validator.Strict, (Lens[])new Lens[]{(Lens)grantType}).toLens();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/http4k/security/oauth/server/accesstoken/GenerateAccessTokenForGrantType$Companion;", "", "()V", "grantType", "Lorg/http4k/lens/BiDiLens;", "Lorg/http4k/lens/WebForm;", "", "getGrantType", "()Lorg/http4k/lens/BiDiLens;", "grantTypeForm", "Lorg/http4k/lens/BiDiBodyLens;", "getGrantTypeForm", "()Lorg/http4k/lens/BiDiBodyLens;", "http4k-security-oauth"})
    public static final class Companion {
        @NotNull
        public final BiDiLens<WebForm, String> getGrantType() {
            return grantType;
        }

        @NotNull
        public final BiDiBodyLens<WebForm> getGrantTypeForm() {
            return grantTypeForm;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

