/*
 * Decompiled with CFR 0.152.
 */
package org.http4k.security.oauth.server;

import com.natpryce.Failure;
import com.natpryce.Result;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.http4k.core.Request;
import org.http4k.core.Uri;
import org.http4k.security.oauth.server.AuthRequest;
import org.http4k.security.oauth.server.AuthoriseRequestValidator;
import org.http4k.security.oauth.server.ClientId;
import org.http4k.security.oauth.server.InvalidAuthorizationRequest;
import org.http4k.security.oauth.server.OAuthError;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J!\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0001J$\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/http4k/security/oauth/server/MustHaveRedirectUri;", "Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;", "delegate", "(Lorg/http4k/security/oauth/server/AuthoriseRequestValidator;)V", "isValidClientAndRedirectUriInCaseOfError", "", "request", "Lorg/http4k/core/Request;", "clientId", "Lorg/http4k/security/oauth/server/ClientId;", "redirectUri", "Lorg/http4k/core/Uri;", "validate", "Lcom/natpryce/Result;", "Lorg/http4k/security/oauth/server/OAuthError;", "authorizationRequest", "Lorg/http4k/security/oauth/server/AuthRequest;", "http4k-security-oauth"})
public final class MustHaveRedirectUri
implements AuthoriseRequestValidator {
    private final AuthoriseRequestValidator delegate;

    @Override
    @NotNull
    public Result<Request, OAuthError> validate(@NotNull Request request2, @NotNull AuthRequest authorizationRequest) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)authorizationRequest, (String)"authorizationRequest");
        if (authorizationRequest.getRedirectUri() == null) {
            return (Result)new Failure((Object)new InvalidAuthorizationRequest("query 'redirect_uri' is required"));
        }
        return this.delegate.validate(request2, authorizationRequest);
    }

    public MustHaveRedirectUri(@NotNull AuthoriseRequestValidator delegate) {
        Intrinsics.checkParameterIsNotNull((Object)delegate, (String)"delegate");
        this.delegate = delegate;
    }

    @Override
    public boolean isValidClientAndRedirectUriInCaseOfError(@NotNull Request request2, @NotNull ClientId clientId, @NotNull Uri redirectUri) {
        Intrinsics.checkParameterIsNotNull((Object)request2, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)clientId, (String)"clientId");
        Intrinsics.checkParameterIsNotNull((Object)redirectUri, (String)"redirectUri");
        return this.delegate.isValidClientAndRedirectUriInCaseOfError(request2, clientId, redirectUri);
    }
}

