/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.util;

import java.util.ArrayList;
import java.util.HashMap;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLComponentManager;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLConfigurationException;

public class ParserConfigurationSettings
implements XMLComponentManager {
    private final ArrayList<String> fRecognizedProperties;
    private final HashMap<String, Object> fProperties;
    private final ArrayList<String> fRecognizedFeatures = new ArrayList();
    private final HashMap<String, Boolean> fFeatures;

    public ParserConfigurationSettings() {
        this.fRecognizedProperties = new ArrayList();
        this.fFeatures = new HashMap();
        this.fProperties = new HashMap();
    }

    public void addRecognizedFeatures(String[] featureIds) {
        int featureIdsCount = featureIds != null ? featureIds.length : 0;
        int i = 0;
        while (i < featureIdsCount) {
            String featureId = featureIds[i];
            if (!this.fRecognizedFeatures.contains(featureId)) {
                this.fRecognizedFeatures.add(featureId);
            }
            ++i;
        }
    }

    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        this.checkFeature(featureId);
        this.fFeatures.put(featureId, state ? Boolean.TRUE : Boolean.FALSE);
    }

    public void addRecognizedProperties(String[] propertyIds) {
        int propertyIdsCount = propertyIds != null ? propertyIds.length : 0;
        int i = 0;
        while (i < propertyIdsCount) {
            String propertyId = propertyIds[i];
            if (!this.fRecognizedProperties.contains(propertyId)) {
                this.fRecognizedProperties.add(propertyId);
            }
            ++i;
        }
    }

    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        this.checkProperty(propertyId);
        this.fProperties.put(propertyId, value);
    }

    @Override
    public boolean getFeature(String featureId) throws XMLConfigurationException {
        Boolean state = this.fFeatures.get(featureId);
        if (state == null) {
            this.checkFeature(featureId);
            return false;
        }
        return state;
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        Object propertyValue = this.fProperties.get(propertyId);
        if (propertyValue == null) {
            this.checkProperty(propertyId);
        }
        return propertyValue;
    }

    protected void checkFeature(String featureId) throws XMLConfigurationException {
        if (!this.fRecognizedFeatures.contains(featureId)) {
            short type = 0;
            throw new XMLConfigurationException(type, featureId);
        }
    }

    protected void checkProperty(String propertyId) throws XMLConfigurationException {
        if (!this.fRecognizedProperties.contains(propertyId)) {
            short type = 0;
            throw new XMLConfigurationException(type, propertyId);
        }
    }
}

