/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.FileAccess;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.store.ValuePool;

public class HsqlProperties {
    public static final int NO_VALUE_FOR_KEY = 1;
    protected String fileName;
    protected Properties stringProps;
    protected int[] errorCodes = ValuePool.emptyIntArray;
    protected String[] errorKeys = ValuePool.emptyStringArray;
    protected boolean resource = false;
    protected FileAccess fa;
    protected HashMap metaData;
    public static final int indexName = 0;
    public static final int indexType = 1;
    public static final int indexClass = 2;
    public static final int indexIsRange = 3;
    public static final int indexDefaultValue = 4;
    public static final int indexRangeLow = 5;
    public static final int indexRangeHigh = 6;
    public static final int indexValues = 7;
    public static final int indexLimit = 9;

    public HsqlProperties() {
        this.stringProps = new Properties();
        this.fileName = null;
    }

    public HsqlProperties(String string) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fa = FileUtil.getFileUtil();
    }

    public HsqlProperties(HashMap hashMap, String string, FileAccess fileAccess, boolean bl) {
        this.stringProps = new Properties();
        this.fileName = string;
        this.fa = fileAccess;
        this.metaData = hashMap;
    }

    public HsqlProperties(Properties properties) {
        this.stringProps = properties;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public String setProperty(String string, int n) {
        return this.setProperty(string, Integer.toString(n));
    }

    public String setProperty(String string, boolean bl) {
        return this.setProperty(string, String.valueOf(bl));
    }

    public String setProperty(String string, String string2) {
        return (String)this.stringProps.put(string, string2);
    }

    public String setPropertyIfNotExists(String string, String string2) {
        string2 = this.getProperty(string, string2);
        return this.setProperty(string, string2);
    }

    public Properties getProperties() {
        return this.stringProps;
    }

    public String getProperty(String string) {
        return this.stringProps.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        return this.stringProps.getProperty(string, string2);
    }

    public int getIntegerProperty(String string, int n) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                n = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public boolean isPropertyTrue(String string) {
        return this.isPropertyTrue(string, false);
    }

    public boolean isPropertyTrue(String string, boolean bl) {
        String string2 = this.stringProps.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        return string2.toLowerCase().equals("true");
    }

    public void removeProperty(String string) {
        this.stringProps.remove(string);
    }

    public void addProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this.stringProps.put(string, string2);
        }
    }

    public void addProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties == null) {
            return;
        }
        this.addProperties(hsqlProperties.stringProps);
    }

    public boolean propertiesFileExists() {
        String string = this.fileName + ".properties";
        return this.fa.isStreamElement(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean load() throws Exception {
        if (!this.propertiesFileExists()) {
            return false;
        }
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(Error.getMessage(28));
        }
        InputStream inputStream = null;
        String string = this.fileName + ".properties";
        try {
            inputStream = this.fa.openInputStreamElement(string);
            this.stringProps.load(inputStream);
            Object var4_3 = null;
            if (inputStream == null) return true;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (inputStream == null) throw throwable;
            inputStream.close();
            throw throwable;
        }
        inputStream.close();
        return true;
    }

    public void save() throws Exception {
        if (this.fileName == null || this.fileName.length() == 0) {
            throw new FileNotFoundException(Error.getMessage(28));
        }
        String string = this.fileName + ".properties";
        this.save(string);
    }

    public void save(String string) throws Exception {
        this.fa.createParentDirs(string);
        OutputStream outputStream = this.fa.openOutputStreamElement(string);
        FileAccess.FileSync fileSync = this.fa.getFileSync(outputStream);
        JavaSystem.saveProperties(this.stringProps, "HSQL Database Engine 2.0.0", outputStream);
        outputStream.flush();
        fileSync.sync();
        outputStream.close();
    }

    private void addError(int n, String string) {
        this.errorCodes = (int[])ArrayUtil.resizeArray(this.errorCodes, this.errorCodes.length + 1);
        this.errorKeys = (String[])ArrayUtil.resizeArray(this.errorKeys, this.errorKeys.length + 1);
        this.errorCodes[this.errorCodes.length - 1] = n;
        this.errorKeys[this.errorKeys.length - 1] = string;
    }

    public static HsqlProperties argArrayToProps(String[] stringArray, String string) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2;
            String string3 = stringArray[i];
            if (string3.equals("--help") || string3.equals("-help")) {
                hsqlProperties.addError(1, string3.substring(1));
                continue;
            }
            if (string3.startsWith("--")) {
                string2 = i + 1 < stringArray.length ? stringArray[i + 1] : "";
                hsqlProperties.setProperty(string + "." + string3.substring(2), string2);
                ++i;
                continue;
            }
            if (string3.charAt(0) != '-') continue;
            string2 = i + 1 < stringArray.length ? stringArray[i + 1] : "";
            hsqlProperties.setProperty(string + "." + string3.substring(1), string2);
            ++i;
        }
        return hsqlProperties;
    }

    public static HsqlProperties delimitedArgPairsToProps(String string, String string2, String string3, String string4) {
        HsqlProperties hsqlProperties = new HsqlProperties();
        int n = 0;
        while (true) {
            int n2;
            int n3;
            if ((n3 = string.indexOf(string3, n)) == -1) {
                n3 = string.length();
            }
            if ((n2 = string.substring(0, n3).indexOf(string2, n)) == -1) {
                hsqlProperties.addError(1, string.substring(n, n3).trim());
            } else {
                String string5 = string.substring(n, n2).trim();
                String string6 = string.substring(n2 + string2.length(), n3).trim();
                if (string4 != null) {
                    string5 = string4 + "." + string5;
                }
                hsqlProperties.setProperty(string5, string6);
            }
            if (n3 == string.length()) break;
            n = n3 + string3.length();
        }
        return hsqlProperties;
    }

    public Enumeration propertyNames() {
        return this.stringProps.propertyNames();
    }

    public boolean isEmpty() {
        return this.stringProps.isEmpty();
    }

    public String[] getErrorKeys() {
        return this.errorKeys;
    }

    public static Object[] getMeta(String string, int n, String string2) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "String";
        objectArray[4] = string2;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n, boolean bl) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "Boolean";
        objectArray[4] = bl ? Boolean.TRUE : Boolean.FALSE;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n, int n2, int[] nArray) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "Integer";
        objectArray[4] = ValuePool.getInt(n2);
        objectArray[7] = nArray;
        return objectArray;
    }

    public static Object[] getMeta(String string, int n, int n2, int n3, int n4) {
        Object[] objectArray = new Object[9];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "Integer";
        objectArray[4] = ValuePool.getInt(n2);
        objectArray[3] = Boolean.TRUE;
        objectArray[5] = ValuePool.getInt(n3);
        objectArray[6] = ValuePool.getInt(n4);
        return objectArray;
    }

    public static String validateProperty(String string, String string2, Object[] objectArray) {
        if (objectArray[2].equals("Boolean")) {
            if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("false")) {
                return null;
            }
            return "invalid boolean value for property: " + string;
        }
        if (objectArray[2].equals("String")) {
            return null;
        }
        if (objectArray[2].equals("Integer")) {
            int[] nArray;
            int n = Integer.parseInt(string2);
            if (Boolean.TRUE.equals(objectArray[3])) {
                int n2 = (Integer)objectArray[5];
                int n3 = (Integer)objectArray[6];
                if (n < n2 || n3 < n) {
                    return "value outside range for property: " + string;
                }
            }
            if (objectArray[7] != null && ArrayUtil.find(nArray = (int[])objectArray[7], n) == -1) {
                return "value not supported for property: " + string;
            }
            return null;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n = this.stringProps.size();
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        for (int i = 0; i < n; ++i) {
            String string = (String)enumeration.nextElement();
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(this.stringProps.get(string));
            if (i + 1 < n) {
                stringBuffer.append(',');
                stringBuffer.append(' ');
            }
            stringBuffer.append(']');
        }
        return stringBuffer.toString();
    }
}

