/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import java.util.TimeZone;
import org.hsqldb.Database;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.ParserCommand;
import org.hsqldb.QueryExpression;
import org.hsqldb.Row;
import org.hsqldb.Scanner;
import org.hsqldb.SessionContext;
import org.hsqldb.SessionData;
import org.hsqldb.SessionInterface;
import org.hsqldb.Statement;
import org.hsqldb.StatementManager;
import org.hsqldb.StatementQuery;
import org.hsqldb.Table;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.CountUpDownLatch;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.result.Result;
import org.hsqldb.result.ResultLob;
import org.hsqldb.rights.Grantee;
import org.hsqldb.rights.User;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class Session
implements SessionInterface {
    private volatile boolean isClosed;
    public Database database;
    private final User sessionUser;
    private User user;
    private Grantee role;
    boolean isReadOnlyDefault;
    int isolationLevelDefault = 2;
    int isolationLevel = 2;
    int actionIndex;
    long actionTimestamp;
    long transactionTimestamp;
    boolean isPreTransaction;
    boolean isTransaction;
    boolean isBatch;
    volatile boolean abortTransaction;
    volatile boolean redoAction;
    HsqlArrayList rowActionList;
    volatile boolean tempUnlocked;
    OrderedHashSet waitedSessions;
    OrderedHashSet waitingSessions;
    OrderedHashSet tempSet;
    CountUpDownLatch latch = new CountUpDownLatch();
    Statement lockStatement;
    final String zoneString;
    final int sessionTimeZoneSeconds;
    int timeZoneSeconds;
    boolean isNetwork;
    private int sessionMaxRows;
    private Number lastIdentity = ValuePool.INTEGER_0;
    private final long sessionId;
    int sessionTxId = -1;
    private boolean script;
    boolean ignoreCase;
    private JDBCConnection intConnection;
    public HsqlNameManager.HsqlName currentSchema;
    public HsqlNameManager.HsqlName loggedSchema;
    ParserCommand parser;
    boolean isProcessingScript;
    boolean isProcessingLog;
    public SessionContext sessionContext;
    int resultMaxMemoryRows;
    public SessionData sessionData;
    public StatementManager statementManager;
    private final long connectTime = System.currentTimeMillis();
    long currentDateSCN;
    long currentTimestampSCN;
    long currentMillis;
    private TimestampData currentDate;
    private TimestampData currentTimestamp;
    private TimestampData localTimestamp;
    private TimeData currentTime;
    private TimeData localTime;
    HashMappedList sessionTables;
    HsqlDeque sqlWarnings;
    Calendar calendar;
    Scanner secondaryScanner;
    SimpleDateFormat simpleDateFormat;
    SimpleDateFormat simpleDateFormatGMT;
    Random randomGenerator = new Random();
    long seed = -1L;
    HsqlProperties clientProperties;

    Session getSession() {
        return this;
    }

    Session(Database database, User user, boolean bl, boolean bl2, long l, String string, int n) {
        this.sessionId = l;
        this.database = database;
        this.user = user;
        this.sessionUser = user;
        this.zoneString = string;
        this.sessionTimeZoneSeconds = n;
        this.timeZoneSeconds = n;
        this.rowActionList = new HsqlArrayList(true);
        this.waitedSessions = new OrderedHashSet();
        this.waitingSessions = new OrderedHashSet();
        this.tempSet = new OrderedHashSet();
        this.isolationLevel = this.isolationLevelDefault = this.database.getDefaultIsolationLevel();
        this.sessionContext = new SessionContext(this);
        this.sessionContext.isAutoCommit = ValuePool.getBoolean(bl);
        this.sessionContext.isReadOnly = ValuePool.getBoolean(bl2);
        this.parser = new ParserCommand(this, new Scanner());
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.resetSchema();
        this.sessionData = new SessionData(this.database, this);
        this.statementManager = new StatementManager(this.database);
    }

    void resetSchema() {
        this.loggedSchema = null;
        this.currentSchema = this.user.getInitialOrDefaultSchema();
    }

    public long getId() {
        return this.sessionId;
    }

    public synchronized void close() {
        if (this.isClosed) {
            return;
        }
        this.rollback(false);
        try {
            this.database.logger.writeToLog(this, "DISCONNECT");
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.sessionData.closeResultCache();
        this.statementManager.reset();
        this.database.sessionManager.removeSession(this);
        this.database.closeIfLast();
        this.database = null;
        this.user = null;
        this.rowActionList = null;
        this.sessionContext.savepoints = null;
        this.intConnection = null;
        this.lastIdentity = null;
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setIsolationDefault(int n) {
        if (n == 1) {
            this.isReadOnlyDefault = true;
        }
        if (n == this.isolationLevelDefault) {
            return;
        }
        this.isolationLevelDefault = n;
        if (!this.isInMidTransaction()) {
            this.isolationLevel = this.isolationLevelDefault;
        }
        this.database.logger.writeToLog(this, this.getSessionIsolationSQL());
    }

    public void setIsolation(int n) {
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        if (n == 1) {
            this.sessionContext.isReadOnly = Boolean.TRUE;
        }
        if (this.isolationLevel != n) {
            this.isolationLevel = n;
            this.database.logger.writeToLog(this, this.getTransactionIsolationSQL());
        }
    }

    public synchronized int getIsolation() {
        return this.isolationLevel;
    }

    void setLastIdentity(Number number) {
        this.lastIdentity = number;
    }

    public Number getLastIdentity() {
        return this.lastIdentity;
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getUsername() {
        return this.user.getNameString();
    }

    public User getUser() {
        return this.user;
    }

    public Grantee getGrantee() {
        return this.user;
    }

    public Grantee getRole() {
        return this.role;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setRole(Grantee grantee) {
        this.role = grantee;
    }

    int getMaxRows() {
        return this.sessionContext.currentMaxRows;
    }

    void setSQLMaxRows(int n) {
        this.sessionMaxRows = n;
    }

    void checkAdmin() {
        this.user.checkAdmin();
    }

    void checkReadWrite() {
        if (this.sessionContext.isReadOnly.booleanValue()) {
            throw Error.error(3706);
        }
    }

    void checkDDLWrite() {
        this.checkReadWrite();
        if (this.isProcessingScript || this.isProcessingLog) {
            return;
        }
    }

    public long getActionTimestamp() {
        return this.actionTimestamp;
    }

    void addDeleteAction(Table table, Row row, int[] nArray) {
        if (this.abortTransaction) {
            // empty if block
        }
        this.database.txManager.addDeleteAction(this, table, row, nArray);
    }

    void addInsertAction(Table table, Row row) {
        this.database.txManager.addInsertAction(this, table, row);
        if (this.abortTransaction) {
            // empty if block
        }
    }

    public synchronized void setAutoCommit(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.isAutoCommit != bl) {
            this.commit(false);
            this.sessionContext.isAutoCommit = ValuePool.getBoolean(bl);
        }
    }

    public void beginAction(Statement statement) {
        this.actionIndex = this.rowActionList.size();
        this.database.txManager.beginAction(this, statement);
        this.database.txManager.beginActionResume(this);
    }

    public void endAction(Result result) {
        this.sessionData.persistentStoreCollection.clearStatementTables();
        if (result.mode == 2) {
            this.sessionData.persistentStoreCollection.clearResultTables(this.actionTimestamp);
            this.database.txManager.rollbackAction(this);
        } else {
            this.database.txManager.completeActions(this);
        }
    }

    public boolean hasLocks(Statement statement) {
        if (this.lockStatement == statement) {
            if (this.isolationLevel == 4 || this.isolationLevel == 8) {
                return true;
            }
            if (statement.getTableNamesForRead().length == 0) {
                return true;
            }
        }
        return false;
    }

    public void startTransaction() {
        this.database.txManager.beginTransaction(this);
    }

    public synchronized void startPhasedTransaction() {
    }

    public synchronized void prepareCommit() {
        if (this.isClosed) {
            throw Error.error(1303);
        }
        if (!this.database.txManager.prepareCommitActions(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
    }

    public synchronized void commit(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        if (!this.isTransaction) {
            this.sessionContext.isReadOnly = ValuePool.getBoolean(this.isReadOnlyDefault);
            this.isolationLevel = this.isolationLevelDefault;
            return;
        }
        if (!this.database.txManager.commitTransaction(this)) {
            this.rollback(false);
            throw Error.error(4861);
        }
        this.endTransaction(true);
        if (this.database != null && this.database.logger.needsCheckpointReset()) {
            Statement statement = ParserCommand.getCheckpointStatement(this.database, false);
            this.executeCompiledStatement(statement, ValuePool.emptyObjectArray);
        }
    }

    public synchronized void rollback(boolean bl) {
        if (this.isClosed) {
            return;
        }
        if (this.sessionContext.depth > 0) {
            return;
        }
        if (!this.isTransaction) {
            this.sessionContext.isReadOnly = ValuePool.getBoolean(this.isReadOnlyDefault);
            this.isolationLevel = this.isolationLevelDefault;
            return;
        }
        try {
            this.database.logger.writeToLog(this, "ROLLBACK");
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
        this.database.txManager.rollback(this);
        this.endTransaction(false);
    }

    private void endTransaction(boolean bl) {
        this.sessionContext.savepoints.clear();
        this.sessionContext.savepointTimestamps.clear();
        this.rowActionList.clear();
        this.sessionData.persistentStoreCollection.clearTransactionTables();
        this.sessionData.closeAllTransactionNavigators();
        this.sessionContext.isReadOnly = ValuePool.getBoolean(this.isReadOnlyDefault);
        this.isolationLevel = this.isolationLevelDefault;
        this.lockStatement = null;
    }

    public synchronized void resetSession() {
        this.rollback(false);
        this.sessionData.closeAllNavigators();
        this.sessionData.persistentStoreCollection.clearAllTables();
        this.sessionData.closeResultCache();
        this.statementManager.reset();
        this.lastIdentity = ValuePool.INTEGER_0;
        this.setResultMemoryRowCount(this.database.getResultMaxMemoryRows());
        this.user = this.sessionUser;
        this.resetSchema();
        this.setZoneSeconds(this.sessionTimeZoneSeconds);
        this.sessionMaxRows = 0;
        this.ignoreCase = false;
    }

    public synchronized void savepoint(String string) {
        int n = this.sessionContext.savepoints.getIndex(string);
        if (n != -1) {
            this.sessionContext.savepoints.remove(string);
            this.sessionContext.savepointTimestamps.remove(n);
        }
        this.sessionContext.savepoints.add(string, ValuePool.getInt(this.rowActionList.size()));
        this.sessionContext.savepointTimestamps.addLast(this.actionTimestamp);
        try {
            this.database.logger.writeToLog(this, Session.getSavepointSQL(string));
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public synchronized void rollbackToSavepoint(String string) {
        if (this.isClosed) {
            return;
        }
        int n = this.sessionContext.savepoints.getIndex(string);
        if (n < 0) {
            throw Error.error(4821, string);
        }
        this.database.txManager.rollbackSavepoint(this, n);
        try {
            this.database.logger.writeToLog(this, Session.getSavepointRollbackSQL(string));
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public synchronized void rollbackToSavepoint() {
        if (this.isClosed) {
            return;
        }
        String string = (String)this.sessionContext.savepoints.getKey(0);
        this.database.txManager.rollbackSavepoint(this, 0);
        try {
            this.database.logger.writeToLog(this, Session.getSavepointRollbackSQL(string));
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    public synchronized void releaseSavepoint(String string) {
        int n = this.sessionContext.savepoints.getIndex(string);
        if (n < 0) {
            throw Error.error(4821, string);
        }
        while (this.sessionContext.savepoints.size() > n) {
            this.sessionContext.savepoints.remove(this.sessionContext.savepoints.size() - 1);
            this.sessionContext.savepointTimestamps.removeLast();
        }
    }

    public boolean isInMidTransaction() {
        return this.isTransaction;
    }

    public void setNoSQL() {
        this.sessionContext.noSQL = Boolean.TRUE;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void setReadOnly(boolean bl) {
        if (!bl && this.database.databaseReadOnly) {
            throw Error.error(455);
        }
        if (this.isInMidTransaction()) {
            throw Error.error(3701);
        }
        this.sessionContext.isReadOnly = ValuePool.getBoolean(bl);
    }

    public synchronized void setReadOnlyDefault(boolean bl) {
        if (!bl && this.database.databaseReadOnly) {
            throw Error.error(455);
        }
        this.isReadOnlyDefault = bl;
        if (!this.isInMidTransaction()) {
            this.sessionContext.isReadOnly = ValuePool.getBoolean(this.isReadOnlyDefault);
        }
    }

    public boolean isReadOnly() {
        return this.sessionContext.isReadOnly;
    }

    public synchronized boolean isReadOnlyDefault() {
        return this.isReadOnlyDefault;
    }

    public synchronized boolean isAutoCommit() {
        return this.sessionContext.isAutoCommit;
    }

    public synchronized int getStreamBlockSize() {
        return 524288;
    }

    void setScripting(boolean bl) {
        this.script = bl;
    }

    boolean isScripting() {
        return this.script;
    }

    JDBCConnection getInternalConnection() {
        if (this.intConnection == null) {
            this.intConnection = new JDBCConnection(this);
        }
        return this.intConnection;
    }

    public boolean isAdmin() {
        return this.user.isAdmin();
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public int getTransactionSize() {
        return this.rowActionList.size();
    }

    public long getTransactionTimestamp() {
        return this.transactionTimestamp;
    }

    public Statement compileStatement(String string, int n) {
        this.parser.reset(string);
        Statement statement = this.parser.compileStatement(n);
        return statement;
    }

    public synchronized Result execute(Result result) {
        if (this.isClosed) {
            return Result.newErrorResult(Error.error(1353));
        }
        this.sessionContext.currentMaxRows = 0;
        this.isBatch = false;
        JavaSystem.gc();
        switch (result.mode) {
            case 18: {
                return this.performLOBOperation((ResultLob)result);
            }
            case 35: {
                long l;
                int n = result.getUpdateCount();
                this.sessionContext.currentMaxRows = n == -1 ? 0 : n;
                Statement statement = result.statement;
                if ((statement == null || statement.compileTimestamp < this.database.schemaManager.schemaChangeTimestamp) && (statement = this.statementManager.getStatement(this, l = result.getStatementID())) == null) {
                    return Result.newErrorResult(Error.error(1252));
                }
                Object[] objectArray = (Object[])result.valueData;
                Result result2 = this.executeCompiledStatement(statement, objectArray);
                result2 = this.performPostExecute(result, result2);
                return result2;
            }
            case 9: {
                this.isBatch = true;
                Result result3 = this.executeCompiledBatchStatement(result);
                result3 = this.performPostExecute(result, result3);
                return result3;
            }
            case 34: {
                Result result4 = this.executeDirectStatement(result);
                result4 = this.performPostExecute(result, result4);
                return result4;
            }
            case 8: {
                this.isBatch = true;
                Result result5 = this.executeDirectBatchStatement(result);
                result5 = this.performPostExecute(result, result5);
                return result5;
            }
            case 37: {
                Statement statement;
                try {
                    statement = this.statementManager.compile(this, result);
                }
                catch (Throwable throwable) {
                    String string = result.getMainString();
                    if (this.database.getProperties().getErrorLevel() == 1) {
                        string = null;
                    }
                    return Result.newErrorResult(throwable, string);
                }
                Result result6 = Result.newPrepareResponse(statement);
                if (statement.getType() == 85 || statement.getType() == 7) {
                    this.sessionData.setResultSetProperties(result, result6);
                }
                result6 = this.performPostExecute(result, result6);
                return result6;
            }
            case 40: {
                this.closeNavigator(result.getResultId());
                return Result.updateZeroResult;
            }
            case 41: {
                Result result7 = this.executeResultUpdate(result);
                result7 = this.performPostExecute(result, result7);
                return result7;
            }
            case 36: {
                this.statementManager.freeStatement(result.getStatementID());
                return Result.updateZeroResult;
            }
            case 7: {
                int n = result.getStatementType();
                return this.getAttributesResult(n);
            }
            case 6: {
                return this.setAttributes(result);
            }
            case 33: {
                switch (result.getActionType()) {
                    case 0: {
                        try {
                            this.commit(false);
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 6: {
                        try {
                            this.commit(true);
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 1: {
                        this.rollback(false);
                        break;
                    }
                    case 7: {
                        this.rollback(true);
                        break;
                    }
                    case 4: {
                        try {
                            String string = result.getMainString();
                            this.releaseSavepoint(string);
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                    case 2: {
                        try {
                            this.rollbackToSavepoint(result.getMainString());
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 38: {
                switch (result.getConnectionAttrType()) {
                    case 10027: {
                        try {
                            this.savepoint(result.getMainString());
                            break;
                        }
                        catch (Throwable throwable) {
                            return Result.newErrorResult(throwable);
                        }
                    }
                }
                return Result.updateZeroResult;
            }
            case 13: {
                return this.sessionData.getDataResultSlice(result.getResultId(), result.getUpdateCount(), result.getFetchSize());
            }
            case 32: {
                this.close();
                return Result.updateZeroResult;
            }
        }
        return Result.newErrorResult(Error.runtimeError(201, "Session"));
    }

    private Result performPostExecute(Result result, Result result2) {
        if (result2.mode == 3) {
            result2 = this.sessionData.getDataResultHead(result, result2, this.isNetwork);
        }
        if (this.sqlWarnings != null && this.sqlWarnings.size() > 0) {
            if (result2.mode == 1) {
                result2 = new Result(1, result2.getUpdateCount());
            }
            HsqlException[] hsqlExceptionArray = this.getAndClearWarnings();
            result2.addWarnings(hsqlExceptionArray);
        }
        return result2;
    }

    public RowSetNavigatorClient getRows(long l, int n, int n2) {
        return this.sessionData.getRowSetSlice(l, n, n2);
    }

    public synchronized void closeNavigator(long l) {
        this.sessionData.closeNavigator(l);
    }

    public Result executeDirectStatement(Result result) {
        HsqlArrayList hsqlArrayList;
        String string = result.getMainString();
        int n = result.getUpdateCount();
        if (n == -1) {
            this.sessionContext.currentMaxRows = 0;
        } else if (this.sessionMaxRows == 0) {
            this.sessionContext.currentMaxRows = n;
        } else {
            this.sessionContext.currentMaxRows = this.sessionMaxRows;
            this.sessionMaxRows = 0;
        }
        try {
            hsqlArrayList = this.parser.compileStatements(string, result);
        }
        catch (Exception exception) {
            return Result.newErrorResult(exception);
        }
        Result result2 = null;
        for (int i = 0; i < hsqlArrayList.size(); ++i) {
            Statement statement = (Statement)hsqlArrayList.get(i);
            statement.setGeneratedColumnInfo(result.getGeneratedResultType(), result.getGeneratedResultMetaData());
            result2 = this.executeCompiledStatement(statement, ValuePool.emptyObjectArray);
            if (result2.mode == 2) break;
        }
        return result2;
    }

    public Result executeDirectStatement(String string, int n) {
        Statement statement;
        this.parser.reset(string);
        try {
            statement = this.parser.compileStatement(n);
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        Result result = this.executeCompiledStatement(statement, ValuePool.emptyObjectArray);
        return result;
    }

    public Result executeCompiledStatement(Statement statement, Object[] objectArray) {
        Result result;
        if (this.abortTransaction) {
            this.rollback(false);
            return Result.newErrorResult(Error.error(4861));
        }
        if (this.sessionContext.depth > 0 && (this.sessionContext.noSQL.booleanValue() || statement.isAutoCommitStatement())) {
            return Result.newErrorResult(Error.error(6000));
        }
        if (statement.isAutoCommitStatement()) {
            if (this.isReadOnly()) {
                return Result.newErrorResult(Error.error(3706));
            }
            try {
                this.commit(false);
            }
            catch (HsqlException hsqlException) {
                this.database.logger.logInfoEvent("Exception at commit");
            }
        }
        this.sessionContext.currentStatement = statement;
        if (!statement.isTransactionStatement()) {
            Result result2 = statement.execute(this);
            this.sessionContext.currentStatement = null;
            return result2;
        }
        while (true) {
            this.actionIndex = this.rowActionList.size();
            this.database.txManager.beginAction(this, statement);
            if (this.abortTransaction) {
                this.rollback(false);
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.abortTransaction) {
                this.rollback(false);
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            this.database.txManager.beginActionResume(this);
            this.sessionContext.setDynamicArguments(objectArray);
            result = statement.execute(this);
            this.lockStatement = this.sessionContext.currentStatement;
            this.endAction(result);
            if (this.abortTransaction) {
                this.rollback(false);
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861));
            }
            if (!this.redoAction) break;
            this.redoAction = false;
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("interrupted");
            }
        }
        if (this.sessionContext.depth == 0 && (this.sessionContext.isAutoCommit.booleanValue() || statement.isAutoCommitStatement())) {
            try {
                if (result.mode == 2) {
                    this.rollback(false);
                } else {
                    this.commit(false);
                }
            }
            catch (Exception exception) {
                this.sessionContext.currentStatement = null;
                return Result.newErrorResult(Error.error(4861, exception));
            }
        }
        this.sessionContext.currentStatement = null;
        return result;
    }

    private Result executeCompiledBatchStatement(Result result) {
        long l = result.getStatementID();
        Statement statement = this.statementManager.getStatement(this, l);
        if (statement == null) {
            return Result.newErrorResult(Error.error(1251));
        }
        int n = 0;
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        Result result2 = null;
        if (statement.hasGeneratedColumns()) {
            result2 = Result.newDataResult(statement.generatedResultMetaData());
        }
        Result result3 = null;
        while (rowSetNavigator.hasNext()) {
            Object[] objectArray = rowSetNavigator.getNext();
            Result result4 = this.executeCompiledStatement(statement, objectArray);
            if (result4.isUpdateCount()) {
                if (statement.hasGeneratedColumns()) {
                    RowSetNavigator rowSetNavigator2 = result4.getChainedResult().getNavigator();
                    while (rowSetNavigator2.hasNext()) {
                        Object[] objectArray2 = rowSetNavigator2.getNext();
                        result2.getNavigator().add(objectArray2);
                    }
                }
                nArray[n++] = result4.getUpdateCount();
                continue;
            }
            if (result4.isData()) {
                nArray[n++] = -2;
                continue;
            }
            if (result4.mode == 2) {
                nArray = ArrayUtil.arraySlice(nArray, 0, n);
                result3 = result4;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(nArray, result2, result3);
    }

    private Result executeDirectBatchStatement(Result result) {
        int n = 0;
        RowSetNavigator rowSetNavigator = result.initialiseNavigator();
        int[] nArray = new int[rowSetNavigator.getSize()];
        Result result2 = null;
        while (rowSetNavigator.hasNext()) {
            Result result3;
            Object[] objectArray = rowSetNavigator.getNext();
            String string = (String)objectArray[0];
            try {
                result3 = this.executeDirectStatement(string, 0);
            }
            catch (Throwable throwable) {
                result3 = Result.newErrorResult(throwable);
            }
            if (result3.isUpdateCount()) {
                nArray[n++] = result3.getUpdateCount();
                continue;
            }
            if (result3.isData()) {
                nArray[n++] = -2;
                continue;
            }
            if (result3.mode == 2) {
                nArray = ArrayUtil.arraySlice(nArray, 0, n);
                result2 = result3;
                break;
            }
            throw Error.runtimeError(201, "Session");
        }
        return Result.newBatchedExecuteResponse(nArray, null, result2);
    }

    private Result executeResultUpdate(Result result) {
        long l = result.getResultId();
        int n = result.getActionType();
        Result result2 = this.sessionData.getDataResult(l);
        if (result2 == null) {
            return Result.newErrorResult(Error.error(3601));
        }
        Object[] objectArray = (Object[])result.valueData;
        Type[] typeArray = result.metaData.columnTypes;
        StatementQuery statementQuery = (StatementQuery)result2.getStatement();
        QueryExpression queryExpression = statementQuery.queryExpression;
        Table table = queryExpression.getBaseTable();
        int[] nArray = queryExpression.getBaseTableColumnMap();
        this.sessionContext.rowUpdateStatement.setRowActionProperties(result2, n, table, typeArray, nArray);
        Result result3 = this.executeCompiledStatement(this.sessionContext.rowUpdateStatement, objectArray);
        return result3;
    }

    public synchronized TimestampData getCurrentDate() {
        this.resetCurrentTimestamp();
        if (this.currentDate == null) {
            this.currentDate = (TimestampData)Type.SQL_DATE.getValue(this.currentMillis / 1000L, 0, this.getZoneSeconds());
        }
        return this.currentDate;
    }

    synchronized TimeData getCurrentTime(boolean bl) {
        this.resetCurrentTimestamp();
        if (bl) {
            if (this.currentTime == null) {
                int n = (int)HsqlDateTime.getNormalisedTime(this.currentMillis) / 1000;
                int n2 = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTime = new TimeData(n, n2, this.getZoneSeconds());
            }
            return this.currentTime;
        }
        if (this.localTime == null) {
            int n = (int)HsqlDateTime.getNormalisedTime(this.currentMillis + (long)(this.getZoneSeconds() * 1000)) / 1000;
            int n3 = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTime = new TimeData(n, n3, 0);
        }
        return this.localTime;
    }

    synchronized TimestampData getCurrentTimestamp(boolean bl) {
        this.resetCurrentTimestamp();
        if (bl) {
            if (this.currentTimestamp == null) {
                int n = (int)(this.currentMillis % 1000L) * 1000000;
                this.currentTimestamp = new TimestampData(this.currentMillis / 1000L, n, this.getZoneSeconds());
            }
            return this.currentTimestamp;
        }
        if (this.localTimestamp == null) {
            int n = (int)(this.currentMillis % 1000L) * 1000000;
            this.localTimestamp = new TimestampData(this.currentMillis / 1000L + (long)this.getZoneSeconds(), n, 0);
        }
        return this.localTimestamp;
    }

    private void resetCurrentTimestamp() {
        if (this.currentTimestampSCN != this.actionTimestamp) {
            this.currentTimestampSCN = this.actionTimestamp;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTimestamp = null;
            this.localTimestamp = null;
            this.currentTime = null;
            this.localTime = null;
        }
    }

    public int getZoneSeconds() {
        return this.timeZoneSeconds;
    }

    public void setZoneSeconds(int n) {
        if (n == this.sessionTimeZoneSeconds) {
            this.calendar = null;
            this.timeZoneSeconds = this.sessionTimeZoneSeconds;
        } else {
            TimeZone timeZone = TimeZone.getDefault();
            timeZone.setRawOffset(n * 1000);
            this.calendar = new GregorianCalendar(timeZone);
            this.timeZoneSeconds = n;
        }
    }

    private Result getAttributesResult(int n) {
        Result result = Result.newSessionAttributesResult();
        Object[] objectArray = result.getSingleRowData();
        objectArray[0] = ValuePool.getInt(n);
        switch (n) {
            case 0: {
                objectArray[1] = ValuePool.getInt(this.isolationLevel);
                break;
            }
            case 1: {
                objectArray[2] = this.sessionContext.isAutoCommit;
                break;
            }
            case 2: {
                objectArray[2] = this.sessionContext.isReadOnly;
                break;
            }
            case 3: {
                objectArray[3] = this.database.getCatalogName().name;
            }
        }
        return result;
    }

    private Result setAttributes(Result result) {
        Object[] objectArray = result.getSessionAttributes();
        int n = (Integer)objectArray[0];
        try {
            switch (n) {
                case 1: {
                    boolean bl = (Boolean)objectArray[2];
                    this.setAutoCommit(bl);
                    break;
                }
                case 2: {
                    boolean bl = (Boolean)objectArray[2];
                    this.setReadOnlyDefault(bl);
                    break;
                }
                case 0: {
                    int n2 = (Integer)objectArray[1];
                    this.setIsolation(n2);
                    break;
                }
                case 3: {
                    String string = (String)objectArray[3];
                    this.setCatalog(string);
                }
            }
        }
        catch (HsqlException hsqlException) {
            return Result.newErrorResult(hsqlException);
        }
        return Result.updateZeroResult;
    }

    public synchronized Object getAttribute(int n) {
        switch (n) {
            case 0: {
                return ValuePool.getInt(this.isolationLevel);
            }
            case 1: {
                return this.sessionContext.isAutoCommit;
            }
            case 2: {
                return this.sessionContext.isReadOnly;
            }
            case 3: {
                return this.database.getCatalogName().name;
            }
        }
        return null;
    }

    public synchronized void setAttribute(int n, Object object) {
        switch (n) {
            case 1: {
                boolean bl = (Boolean)object;
                this.setAutoCommit(bl);
                break;
            }
            case 2: {
                boolean bl = (Boolean)object;
                this.setReadOnlyDefault(bl);
                break;
            }
            case 0: {
                int n2 = (Integer)object;
                this.setIsolation(n2);
                break;
            }
            case 3: {
                String string = (String)object;
                this.setCatalog(string);
            }
        }
    }

    public BlobDataID createBlob(long l) {
        long l2 = this.database.lobManager.createBlob(l);
        if (l2 == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.addToCreatedLobs(l2);
        return new BlobDataID(l2);
    }

    public ClobDataID createClob(long l) {
        long l2 = this.database.lobManager.createClob(l);
        if (l2 == 0L) {
            throw Error.error(3474);
        }
        this.sessionData.addToCreatedLobs(l2);
        return new ClobDataID(l2);
    }

    public void registerResultLobs(Result result) {
        this.sessionData.registerLobForResult(result);
    }

    public void allocateResultLob(ResultLob resultLob, InputStream inputStream) {
        this.sessionData.allocateLobForResult(resultLob, inputStream);
    }

    Result performLOBOperation(ResultLob resultLob) {
        long l = resultLob.getLobID();
        int n = resultLob.getSubType();
        switch (n) {
            case 11: {
                return this.database.lobManager.getLob(l, resultLob.getOffset(), resultLob.getBlockLength());
            }
            case 10: {
                return this.database.lobManager.getLength(l);
            }
            case 1: {
                return this.database.lobManager.getBytes(l, resultLob.getOffset(), (int)resultLob.getBlockLength());
            }
            case 2: {
                return this.database.lobManager.setBytes(l, resultLob.getByteArray(), resultLob.getOffset());
            }
            case 3: {
                return this.database.lobManager.getChars(l, resultLob.getOffset(), (int)resultLob.getBlockLength());
            }
            case 4: {
                return this.database.lobManager.setChars(l, resultLob.getOffset(), resultLob.getCharArray());
            }
            case 9: {
                throw Error.error(1551);
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw Error.error(1551);
            }
        }
        throw Error.runtimeError(201, "Session");
    }

    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }

    boolean isProcessingScript() {
        return this.isProcessingScript;
    }

    boolean isProcessingLog() {
        return this.isProcessingLog;
    }

    public void setSchema(String string) {
        this.currentSchema = this.database.schemaManager.getSchemaHsqlName(string);
    }

    public void setCatalog(String string) {
        if (this.database.getCatalogName().name.equals(string)) {
            return;
        }
        throw Error.error(4840);
    }

    HsqlNameManager.HsqlName getSchemaHsqlName(String string) {
        return string == null ? this.currentSchema : this.database.schemaManager.getSchemaHsqlName(string);
    }

    public String getSchemaName(String string) {
        return string == null ? this.currentSchema.name : this.database.schemaManager.getSchemaName(string);
    }

    public void setCurrentSchemaHsqlName(HsqlNameManager.HsqlName hsqlName) {
        this.currentSchema = hsqlName;
    }

    public HsqlNameManager.HsqlName getCurrentSchemaHsqlName() {
        return this.currentSchema;
    }

    public void addSessionTable(Table table) {
        if (this.sessionTables == null) {
            this.sessionTables = new HashMappedList();
        }
        if (this.sessionTables.containsKey(table.getName().name)) {
            throw Error.error(5504);
        }
        this.sessionTables.add(table.getName().name, table);
    }

    public void setSessionTables(Table[] tableArray) {
    }

    public Table findSessionTable(String string) {
        if (this.sessionTables == null) {
            return null;
        }
        return (Table)this.sessionTables.get(string);
    }

    public void dropSessionTable(String string) {
        this.sessionTables.remove(string);
    }

    public int getResultMemoryRowCount() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMemoryRowCount(int n) {
        if (this.database.logger.getTempDirectoryPath() != null) {
            if (n < 0) {
                n = 0;
            }
            this.resultMaxMemoryRows = n;
        }
    }

    public void addWarning(HsqlException hsqlException) {
        int n;
        if (this.sqlWarnings == null) {
            this.sqlWarnings = new HsqlDeque();
        }
        if (this.sqlWarnings.size() > 9) {
            this.sqlWarnings.removeFirst();
        }
        if ((n = this.sqlWarnings.indexOf(hsqlException)) >= 0) {
            this.sqlWarnings.remove(n);
        }
        this.sqlWarnings.add(hsqlException);
    }

    public HsqlException[] getAndClearWarnings() {
        if (this.sqlWarnings == null) {
            return HsqlException.emptyArray;
        }
        Object[] objectArray = new HsqlException[this.sqlWarnings.size()];
        this.sqlWarnings.toArray(objectArray);
        this.sqlWarnings.clear();
        return objectArray;
    }

    public HsqlException getLastWarning() {
        if (this.sqlWarnings == null || this.sqlWarnings.size() == 0) {
            return null;
        }
        return (HsqlException)this.sqlWarnings.getLast();
    }

    public void clearWarnings() {
        if (this.sqlWarnings != null) {
            this.sqlWarnings.clear();
        }
    }

    public Calendar getCalendar() {
        if (this.calendar == null) {
            if (this.zoneString == null) {
                this.calendar = new GregorianCalendar();
            } else {
                TimeZone timeZone = TimeZone.getTimeZone(this.zoneString);
                this.calendar = new GregorianCalendar(timeZone);
            }
        }
        return this.calendar;
    }

    public double random(long l) {
        if (this.seed != l) {
            this.randomGenerator.setSeed(l);
            this.seed = l;
        }
        return this.randomGenerator.nextDouble();
    }

    public double random() {
        return this.randomGenerator.nextDouble();
    }

    public Scanner getScanner() {
        if (this.secondaryScanner == null) {
            this.secondaryScanner = new Scanner();
        }
        return this.secondaryScanner;
    }

    public HsqlProperties getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new HsqlProperties();
            this.clientProperties.setProperty("jdbc.translate_dti_types", this.database.getProperties().isPropertyTrue("jdbc.translate_dti_types"));
        }
        return this.clientProperties;
    }

    public SimpleDateFormat getSimpleDateFormatGMT() {
        if (this.simpleDateFormatGMT == null) {
            this.simpleDateFormatGMT = new SimpleDateFormat("MMMM", Locale.ENGLISH);
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            this.simpleDateFormatGMT.setCalendar(gregorianCalendar);
        }
        return this.simpleDateFormatGMT;
    }

    void logSequences() {
        OrderedHashSet orderedHashSet = this.sessionData.sequenceUpdateSet;
        if (orderedHashSet == null || orderedHashSet.isEmpty()) {
            return;
        }
        int n = orderedHashSet.size();
        for (int i = 0; i < n; ++i) {
            NumberSequence numberSequence = (NumberSequence)orderedHashSet.get(i);
            this.database.logger.writeSequenceStatement(this, numberSequence);
        }
        this.sessionData.sequenceUpdateSet.clear();
    }

    static String getSavepointSQL(String string) {
        StringBuffer stringBuffer = new StringBuffer("SAVEPOINT");
        stringBuffer.append(' ').append('\"').append(string).append('\"');
        return stringBuffer.toString();
    }

    static String getSavepointRollbackSQL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ROLLBACK").append(' ').append("TO").append(' ');
        stringBuffer.append("SAVEPOINT").append(' ');
        stringBuffer.append('\"').append(string).append('\"');
        return stringBuffer.toString();
    }

    String getStartTransactionSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("START").append(' ').append("TRANSACTION");
        if (this.isolationLevel != this.isolationLevelDefault) {
            stringBuffer.append(' ');
            Session.appendIsolationSQL(stringBuffer, this.isolationLevel);
        }
        return stringBuffer.toString();
    }

    String getTransactionIsolationSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ').append("TRANSACTION");
        stringBuffer.append(' ');
        Session.appendIsolationSQL(stringBuffer, this.isolationLevel);
        return stringBuffer.toString();
    }

    String getSessionIsolationSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SET").append(' ').append("SESSION");
        stringBuffer.append(' ').append("CHARACTERISTICS").append(' ');
        stringBuffer.append("AS").append(' ').append("TRANSACTION").append(' ');
        Session.appendIsolationSQL(stringBuffer, this.isolationLevelDefault);
        return stringBuffer.toString();
    }

    static void appendIsolationSQL(StringBuffer stringBuffer, int n) {
        stringBuffer.append("ISOLATION").append(' ');
        stringBuffer.append("LEVEL").append(' ');
        stringBuffer.append(Session.getIsolationString(n));
    }

    static String getIsolationString(int n) {
        switch (n) {
            case 1: 
            case 2: {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("READ").append(' ');
                stringBuffer.append("COMMITTED");
                return stringBuffer.toString();
            }
        }
        return "SERIALIZABLE";
    }

    String getSetSchemaStatement() {
        return "SET SCHEMA " + this.currentSchema.statementName;
    }
}

