/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.ArrayList;
import org.hibernate.FetchMode;
import org.hibernate.boot.spi.SecondPass;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.binder.AbstractBinder;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.BinderUtils;
import org.hibernate.tool.internal.reveng.binder.CollectionPropertyBinder;
import org.hibernate.tool.internal.reveng.binder.CollectionSecondPass;
import org.hibernate.tool.internal.reveng.binder.ForeignKeyUtils;
import org.hibernate.tool.internal.reveng.binder.TypeUtils;

class OneToManyBinder
extends AbstractBinder {
    private final CollectionPropertyBinder collectionPropertyBinder;

    static OneToManyBinder create(BinderContext binderContext) {
        return new OneToManyBinder(binderContext);
    }

    private OneToManyBinder(BinderContext binderContext) {
        super(binderContext);
        this.collectionPropertyBinder = CollectionPropertyBinder.create(binderContext);
    }

    Property bind(PersistentClass rc, ForeignKey foreignKey) {
        Collection collection = this.bindCollection(rc, foreignKey);
        this.getMetadataCollector().addCollectionBinding(collection);
        return this.collectionPropertyBinder.bind(StringHelper.unqualify((String)collection.getRole()), true, rc.getTable(), foreignKey, collection, true);
    }

    private Collection bindCollection(PersistentClass pc, ForeignKey foreignKey) {
        Table table = foreignKey.getTable();
        Set collection = new Set(this.getMetadataBuildingContext(), pc);
        collection.setCollectionTable(table);
        boolean manyToMany = this.getRevengStrategy().isManyToManyTable(table);
        if (manyToMany) {
            this.bindManyToMany(pc, foreignKey, (Collection)collection);
        } else {
            this.bindOneToMany(pc, foreignKey, (Collection)collection);
        }
        collection.setKey(this.createKeyValue(table, foreignKey, this.getReferencedKeyValue((Collection)collection)));
        return collection;
    }

    private KeyValue createKeyValue(Table collectionTable, ForeignKey foreignKey, KeyValue referencedKeyValue) {
        DependantValue keyValue = new DependantValue(this.getMetadataBuildingContext(), collectionTable, referencedKeyValue);
        for (Column fkcolumn : foreignKey.getColumns()) {
            if (fkcolumn.getSqlTypeCode() != null) {
                TypeUtils.determinePreferredType(this.getMetadataCollector(), this.getRevengStrategy(), collectionTable, fkcolumn, false);
            }
            keyValue.addColumn(fkcolumn);
        }
        return keyValue;
    }

    private KeyValue getReferencedKeyValue(Collection collection) {
        String propRef = collection.getReferencedPropertyName();
        if (propRef == null) {
            return collection.getOwner().getIdentifier();
        }
        return (KeyValue)collection.getOwner().getProperty(propRef).getValue();
    }

    private void bindManyToMany(PersistentClass pc, ForeignKey fromForeignKey, Collection collection) {
        ForeignKey toForeignKey = this.getToForeignKey(fromForeignKey);
        this.bindCollection(pc, fromForeignKey, toForeignKey, collection);
        ManyToOne manyToOne = new ManyToOne(this.getMetadataBuildingContext(), collection.getCollectionTable());
        manyToOne.setReferencedEntityName(this.getTableToClassName(toForeignKey.getReferencedTable()));
        this.addColumns(manyToOne, toForeignKey);
        collection.setElement((Value)manyToOne);
    }

    private void addColumns(ManyToOne manyToOne, ForeignKey fk) {
        for (Column fkcolumn : fk.getColumns()) {
            if (fkcolumn.getSqlTypeCode() != null) {
                TypeUtils.determinePreferredType(this.getMetadataCollector(), this.getRevengStrategy(), fk.getTable(), fkcolumn, false);
            }
            manyToOne.addColumn(fkcolumn);
        }
    }

    private ForeignKey getToForeignKey(ForeignKey fromForeignKey) {
        ArrayList<ForeignKey> keys = new ArrayList<ForeignKey>();
        for (ForeignKey foreignKey : fromForeignKey.getTable().getForeignKeys().values()) {
            if (foreignKey == fromForeignKey) continue;
            keys.add(foreignKey);
        }
        if (keys.size() > 1) {
            throw new RuntimeException("more than one other foreign key to choose from!");
        }
        return (ForeignKey)keys.get(0);
    }

    private void bindOneToMany(PersistentClass pc, ForeignKey fromForeignKey, Collection collection) {
        this.bindCollection(pc, fromForeignKey, null, collection);
        OneToMany oneToMany = new OneToMany(this.getMetadataBuildingContext(), collection.getOwner());
        oneToMany.setReferencedEntityName(this.getTableToClassName(fromForeignKey.getTable()));
        this.getMetadataCollector().addSecondPass((SecondPass)new CollectionSecondPass(this.getMetadataBuildingContext(), collection));
        collection.setElement((Value)oneToMany);
    }

    private void bindCollection(PersistentClass pc, ForeignKey fromForeignKey, ForeignKey toForeignKey, Collection collection) {
        ForeignKey targetKey = toForeignKey != null ? toForeignKey : fromForeignKey;
        collection.setRole(this.getFullRolePath(pc, fromForeignKey, toForeignKey));
        collection.setInverse(this.isCollectionInverse(targetKey));
        collection.setLazy(this.isCollectionLazy(targetKey));
        collection.setFetchMode(FetchMode.SELECT);
    }

    private boolean isCollectionLazy(ForeignKey foreignKey) {
        return this.getRevengStrategy().isForeignKeyCollectionLazy(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns());
    }

    private boolean isCollectionInverse(ForeignKey foreignKey) {
        return this.getRevengStrategy().isForeignKeyCollectionInverse(foreignKey.getName(), foreignKey.getTable(), foreignKey.getColumns(), foreignKey.getReferencedTable(), foreignKey.getReferencedColumns());
    }

    private String getTableToClassName(Table table) {
        return this.getRevengStrategy().tableToClassName(TableIdentifier.create(table));
    }

    private String getFullRolePath(PersistentClass pc, ForeignKey fromForeignKey, ForeignKey toForeignKey) {
        String collectionRole = null;
        collectionRole = toForeignKey == null ? this.getForeignKeyToCollectionName(fromForeignKey) : this.getForeignKeyToManyToManyName(fromForeignKey, toForeignKey);
        collectionRole = BinderUtils.makeUnique(pc, collectionRole);
        return StringHelper.qualify((String)pc.getEntityName(), (String)collectionRole);
    }

    private String getForeignKeyToCollectionName(ForeignKey foreignKey) {
        return this.getRevengStrategy().foreignKeyToCollectionName(foreignKey.getName(), TableIdentifier.create(foreignKey.getTable()), foreignKey.getColumns(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), ForeignKeyUtils.isUniqueReference(foreignKey));
    }

    private String getForeignKeyToManyToManyName(ForeignKey fromForeignKey, ForeignKey toForeignKey) {
        return this.getRevengStrategy().foreignKeyToManyToManyName(fromForeignKey, TableIdentifier.create(fromForeignKey.getTable()), toForeignKey, ForeignKeyUtils.isUniqueReference(toForeignKey));
    }
}

