/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.spi;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.FromDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.ToDocumentValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.spi.SearchIndexScope;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldContext;
import org.hibernate.search.engine.search.common.spi.SearchIndexValueFieldTypeContext;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementTypeKey;

public abstract class AbstractIndexValueFieldType<SC extends SearchIndexScope<?>, N extends SearchIndexValueFieldContext<SC>, F>
implements IndexValueFieldTypeDescriptor,
IndexFieldType<F>,
SearchIndexValueFieldTypeContext<SC, N, F> {
    private final Class<F> valueClass;
    private final DslConverter<F, F> rawDslConverter;
    private final ProjectionConverter<F, F> rawProjectionConverter;
    private final DslConverter<?, F> dslConverter;
    private final ProjectionConverter<F, ?> projectionConverter;
    private final boolean searchable;
    private final boolean sortable;
    private final boolean projectable;
    private final boolean aggregable;
    private final Map<SearchQueryElementTypeKey<?>, SearchQueryElementFactory<?, ? super SC, ? super N>> queryElementFactories;
    private final String analyzerName;
    private final String searchAnalyzerName;
    private final String normalizerName;

    protected AbstractIndexValueFieldType(Builder<SC, N, F> builder) {
        this.valueClass = ((Builder)builder).valueClass;
        this.rawDslConverter = ((Builder)builder).rawDslConverter;
        this.rawProjectionConverter = ((Builder)builder).rawProjectionConverter;
        this.dslConverter = ((Builder)builder).dslConverter != null ? ((Builder)builder).dslConverter : this.rawDslConverter;
        this.projectionConverter = ((Builder)builder).projectionConverter != null ? ((Builder)builder).projectionConverter : this.rawProjectionConverter;
        this.searchable = ((Builder)builder).searchable;
        this.sortable = ((Builder)builder).sortable;
        this.projectable = ((Builder)builder).projectable;
        this.aggregable = ((Builder)builder).aggregable;
        this.queryElementFactories = ((Builder)builder).queryElementFactories;
        this.analyzerName = ((Builder)builder).analyzerName;
        this.searchAnalyzerName = ((Builder)builder).searchAnalyzerName != null ? ((Builder)builder).searchAnalyzerName : ((Builder)builder).analyzerName;
        this.normalizerName = ((Builder)builder).normalizerName;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[valueClass=" + this.valueClass.getName() + ", analyzerName=" + this.analyzerName + ", searchAnalyzerName=" + this.searchAnalyzerName + ", normalizerName=" + this.normalizerName + ", capabilities=" + this.queryElementFactories.keySet() + "]";
    }

    @Override
    public final Class<F> valueClass() {
        return this.valueClass;
    }

    @Override
    public final boolean searchable() {
        return this.searchable;
    }

    @Override
    public final boolean sortable() {
        return this.sortable;
    }

    @Override
    public final boolean projectable() {
        return this.projectable;
    }

    @Override
    public final boolean aggregable() {
        return this.aggregable;
    }

    @Override
    public final Class<?> dslArgumentClass() {
        return this.dslConverter.valueType();
    }

    @Override
    public final DslConverter<?, F> dslConverter() {
        return this.dslConverter;
    }

    @Override
    public final DslConverter<F, F> rawDslConverter() {
        return this.rawDslConverter;
    }

    @Override
    public final Class<?> projectedValueClass() {
        return this.projectionConverter.valueType();
    }

    @Override
    public final ProjectionConverter<F, ?> projectionConverter() {
        return this.projectionConverter;
    }

    @Override
    public final ProjectionConverter<F, F> rawProjectionConverter() {
        return this.rawProjectionConverter;
    }

    @Override
    public final Optional<String> analyzerName() {
        return Optional.ofNullable(this.analyzerName);
    }

    @Override
    public final Optional<String> normalizerName() {
        return Optional.ofNullable(this.normalizerName);
    }

    @Override
    public final Optional<String> searchAnalyzerName() {
        return Optional.ofNullable(this.searchAnalyzerName);
    }

    @Override
    public final <T> SearchQueryElementFactory<? extends T, ? super SC, ? super N> queryElementFactory(SearchQueryElementTypeKey<T> key) {
        return this.queryElementFactories.get(key);
    }

    public static abstract class Builder<SC extends SearchIndexScope<?>, N extends SearchIndexValueFieldContext<SC>, F> {
        private final Class<F> valueClass;
        private final DslConverter<F, F> rawDslConverter;
        private final ProjectionConverter<F, F> rawProjectionConverter;
        private DslConverter<?, F> dslConverter;
        private ProjectionConverter<F, ?> projectionConverter;
        private boolean searchable;
        private boolean sortable;
        private boolean projectable;
        private boolean aggregable;
        private final Map<SearchQueryElementTypeKey<?>, SearchQueryElementFactory<?, ? super SC, ? super N>> queryElementFactories = new HashMap();
        private String analyzerName;
        private String searchAnalyzerName;
        private String normalizerName;

        public Builder(Class<F> valueClass) {
            this.valueClass = valueClass;
            this.rawDslConverter = DslConverter.passThrough(valueClass);
            this.rawProjectionConverter = ProjectionConverter.passThrough(valueClass);
        }

        public final Class<F> valueClass() {
            return this.valueClass;
        }

        public final <V> void dslConverter(Class<V> valueType, ToDocumentValueConverter<V, ? extends F> toIndexConverter) {
            this.dslConverter = new DslConverter<V, F>(valueType, toIndexConverter);
        }

        public final <V> void projectionConverter(Class<V> valueType, FromDocumentValueConverter<? super F, V> fromIndexConverter) {
            this.projectionConverter = new ProjectionConverter<F, V>(valueType, fromIndexConverter);
        }

        public final void searchable(boolean searchable) {
            this.searchable = searchable;
        }

        public final void sortable(boolean sortable) {
            this.sortable = sortable;
        }

        public final void projectable(boolean projectable) {
            this.projectable = projectable;
        }

        public final void aggregable(boolean aggregable) {
            this.aggregable = aggregable;
        }

        public final <T> void queryElementFactory(SearchQueryElementTypeKey<T> key, SearchQueryElementFactory<? extends T, ? super SC, ? super N> factory) {
            this.queryElementFactories.put(key, factory);
        }

        public final void analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        public final void searchAnalyzerName(String searchAnalyzerName) {
            this.searchAnalyzerName = searchAnalyzerName;
        }

        public final void normalizerName(String normalizerName) {
            this.normalizerName = normalizerName;
        }

        public abstract AbstractIndexValueFieldType<SC, N, F> build();
    }
}

