/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import java.util.function.Function;
import org.hibernate.search.engine.cfg.impl.AbstractConfigurationProperty;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.OptionalConfigurationProperty;

final class OptionalConfigurationPropertyImpl<T>
extends AbstractConfigurationProperty<Optional<T>>
implements OptionalConfigurationProperty<T> {
    private final Function<Object, T> converter;

    OptionalConfigurationPropertyImpl(String key, Function<Object, T> converter) {
        super(key);
        this.converter = converter;
    }

    @Override
    public <R> Optional<R> getAndMap(ConfigurationPropertySource source, Function<T, R> transform) {
        return this.getAndTransform(source, optional -> optional.map(transform));
    }

    @Override
    public T getOrThrow(ConfigurationPropertySource source, Function<String, RuntimeException> exceptionFunction) {
        return ((Optional)this.get(source)).orElseThrow(() -> (RuntimeException)exceptionFunction.apply(this.resolveOrRaw(source)));
    }

    @Override
    public <R> R getAndMapOrThrow(ConfigurationPropertySource source, Function<T, R> transform, Function<String, RuntimeException> exceptionFunction) {
        return (R)this.getAndTransform(source, optional -> optional.map(transform)).orElseThrow(() -> (RuntimeException)exceptionFunction.apply(this.resolveOrRaw(source)));
    }

    @Override
    <R> R convert(Optional<?> rawValue, Function<Optional<T>, R> transform) {
        return transform.apply(rawValue.map(this.converter));
    }
}

