/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.time.temporal.TemporalAccessor;
import org.hibernate.search.backend.lucene.search.projection.impl.LuceneFieldProjection;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneNumericRangeAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneNumericTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneStandardIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexValueFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneExistsPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericMatchPredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericRangePredicate;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNumericTermsPredicate;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneStandardFieldSort;
import org.hibernate.search.engine.backend.types.Sortable;
import org.hibernate.search.engine.search.aggregation.spi.AggregationTypeKeys;
import org.hibernate.search.engine.search.predicate.spi.PredicateTypeKeys;
import org.hibernate.search.engine.search.projection.spi.ProjectionTypeKeys;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;

abstract class AbstractLuceneTemporalIndexFieldTypeOptionsStep<S extends AbstractLuceneTemporalIndexFieldTypeOptionsStep<S, F>, F extends TemporalAccessor>
extends AbstractLuceneStandardIndexFieldTypeOptionsStep<S, F> {
    private Sortable sortable = Sortable.DEFAULT;

    AbstractLuceneTemporalIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, Class<F> fieldType) {
        super(buildContext, fieldType);
    }

    public S sortable(Sortable sortable) {
        this.sortable = sortable;
        return (S)((AbstractLuceneTemporalIndexFieldTypeOptionsStep)this.thisAsS());
    }

    @Override
    public LuceneIndexValueFieldType<F> toIndexFieldType() {
        boolean resolvedSearchable = AbstractLuceneTemporalIndexFieldTypeOptionsStep.resolveDefault(this.searchable);
        boolean resolvedSortable = AbstractLuceneTemporalIndexFieldTypeOptionsStep.resolveDefault(this.sortable);
        boolean resolvedProjectable = AbstractLuceneTemporalIndexFieldTypeOptionsStep.resolveDefault(this.projectable);
        boolean resolvedAggregable = AbstractLuceneTemporalIndexFieldTypeOptionsStep.resolveDefault(this.aggregable);
        Indexing indexing = resolvedSearchable ? Indexing.ENABLED : Indexing.DISABLED;
        DocValues docValues = resolvedSortable || resolvedAggregable ? DocValues.ENABLED : DocValues.DISABLED;
        Storage storage = resolvedProjectable ? Storage.ENABLED : Storage.DISABLED;
        AbstractLuceneNumericFieldCodec<TemporalAccessor, ?> codec = this.createCodec(indexing, docValues, storage, (TemporalAccessor)this.indexNullAsValue);
        this.builder.codec(codec);
        if (resolvedSearchable) {
            this.builder.searchable(true);
            this.builder.queryElementFactory(PredicateTypeKeys.MATCH, new LuceneNumericMatchPredicate.Factory(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.RANGE, new LuceneNumericRangePredicate.Factory(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.TERMS, new LuceneNumericTermsPredicate.Factory(codec));
            this.builder.queryElementFactory(PredicateTypeKeys.EXISTS, DocValues.ENABLED.equals((Object)docValues) ? new LuceneExistsPredicate.DocValuesOrNormsBasedFactory() : new LuceneExistsPredicate.DefaultFactory());
        }
        if (resolvedSortable) {
            this.builder.sortable(true);
            this.builder.queryElementFactory(SortTypeKeys.FIELD, new LuceneStandardFieldSort.TemporalFieldFactory(codec));
        }
        if (resolvedProjectable) {
            this.builder.projectable(true);
            this.builder.queryElementFactory(ProjectionTypeKeys.FIELD, new LuceneFieldProjection.Factory(codec));
        }
        if (resolvedAggregable) {
            this.builder.aggregable(true);
            this.builder.queryElementFactory(AggregationTypeKeys.TERMS, new LuceneNumericTermsAggregation.Factory<TemporalAccessor>(codec));
            this.builder.queryElementFactory(AggregationTypeKeys.RANGE, new LuceneNumericRangeAggregation.Factory<TemporalAccessor>(codec));
        }
        return this.builder.build();
    }

    protected abstract AbstractLuceneNumericFieldCodec<F, ?> createCodec(Indexing var1, DocValues var2, Storage var3, F var4);
}

