/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.orchestration.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IndexAccessor;
import org.hibernate.search.backend.lucene.orchestration.impl.IndexAccessorWorkExecutionContext;
import org.hibernate.search.backend.lucene.work.impl.IndexManagementWork;
import org.hibernate.search.backend.lucene.work.impl.IndexingWork;
import org.hibernate.search.engine.backend.orchestration.spi.BatchedWorkProcessor;
import org.hibernate.search.util.common.reporting.EventContext;

public class LuceneBatchedWorkProcessor
implements BatchedWorkProcessor {
    private final IndexAccessor indexAccessor;
    private final IndexAccessorWorkExecutionContext context;

    public LuceneBatchedWorkProcessor(EventContext eventContext, IndexAccessor indexAccessor) {
        this.indexAccessor = indexAccessor;
        this.context = new IndexAccessorWorkExecutionContext(eventContext, indexAccessor);
    }

    public void beginBatch() {
    }

    public CompletableFuture<?> endBatch() {
        try {
            this.indexAccessor.commitOrDelay();
        }
        catch (RuntimeException e) {
            this.indexAccessor.cleanUpAfterFailure(e, "Commit after a batch of index works");
        }
        return CompletableFuture.completedFuture(null);
    }

    public void complete() {
        try {
            this.indexAccessor.commitOrDelay();
        }
        catch (RuntimeException e) {
            this.indexAccessor.cleanUpAfterFailure(e, "Commit after completion of all remaining index works");
        }
    }

    public <T> T submit(IndexManagementWork<T> work) {
        try {
            return work.execute(this.context);
        }
        catch (RuntimeException e) {
            this.indexAccessor.cleanUpAfterFailure(e, work.getInfo());
            throw e;
        }
    }

    public <T> T submit(IndexingWork<T> work) {
        try {
            return work.execute(this.context);
        }
        catch (RuntimeException e) {
            this.indexAccessor.cleanUpAfterFailure(e, work.getInfo());
            throw e;
        }
    }

    public void forceCommit() {
        try {
            this.indexAccessor.commit();
        }
        catch (RuntimeException e) {
            this.indexAccessor.cleanUpAfterFailure(e, "Commit after a set of index works");
            throw e;
        }
    }

    public void forceRefresh() {
        this.indexAccessor.refresh();
    }
}

