/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import org.hibernate.search.backend.lucene.lowlevel.collector.impl.DocumentReferenceCollector;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.projection.impl.AbstractLuceneProjection;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.backend.common.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.DocumentReferenceProjectionBuilder;

class LuceneDocumentReferenceProjection
extends AbstractLuceneProjection<DocumentReference, DocumentReference> {
    private LuceneDocumentReferenceProjection(LuceneSearchContext searchContext) {
        super(searchContext);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void request(SearchProjectionRequestContext context) {
        context.requireCollector(DocumentReferenceCollector.FACTORY);
    }

    @Override
    public DocumentReference extract(ProjectionHitMapper<?, ?> mapper, LuceneResult documentResult, SearchProjectionExtractContext context) {
        return context.getCollector(DocumentReferenceCollector.KEY).get(documentResult.getDocId());
    }

    @Override
    public DocumentReference transform(LoadingResult<?, ?> loadingResult, DocumentReference extractedData, SearchProjectionTransformContext context) {
        return extractedData;
    }

    public static class Builder
    extends AbstractLuceneProjection.AbstractBuilder<DocumentReference>
    implements DocumentReferenceProjectionBuilder {
        public Builder(LuceneSearchContext searchContext) {
            super(searchContext);
        }

        public SearchProjection<DocumentReference> build() {
            return new LuceneDocumentReferenceProjection(this.searchContext);
        }
    }
}

