/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.document.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.hibernate.search.backend.lucene.document.impl.AbstractLuceneDocumentElementBuilder;
import org.hibernate.search.backend.lucene.document.impl.LuceneDocumentContentImpl;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.multitenancy.impl.MultiTenancyStrategy;

public class LuceneRootDocumentBuilder
extends AbstractLuceneDocumentElementBuilder {
    private final MultiTenancyStrategy multiTenancyStrategy;

    LuceneRootDocumentBuilder(LuceneIndexModel model, MultiTenancyStrategy multiTenancyStrategy) {
        super(model, model.root(), new LuceneDocumentContentImpl());
        this.multiTenancyStrategy = multiTenancyStrategy;
    }

    public LuceneIndexEntry build(String tenantId, String id, String routingKey) {
        return new LuceneIndexEntry(this.model.hibernateSearchName(), id, this.assembleDocuments(this.multiTenancyStrategy, tenantId, id, routingKey));
    }

    @Override
    void ensureDynamicValueDetectedByExistsPredicateOnObjectField() {
    }

    private List<Document> assembleDocuments(MultiTenancyStrategy multiTenancyStrategy, String tenantId, String id, String routingKey) {
        Document document = this.documentContent.finalizeDocument(multiTenancyStrategy, tenantId, routingKey);
        document.add(MetadataFields.searchableMetadataField(MetadataFields.typeFieldName(), "main"));
        document.add(MetadataFields.searchableRetrievableMetadataField(MetadataFields.idFieldName(), id));
        ArrayList<Document> documents = new ArrayList<Document>();
        this.contribute(multiTenancyStrategy, tenantId, routingKey, id, documents);
        documents.add(document);
        return documents;
    }
}

