/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.annotation.processing.FilerException;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.Context;
import org.hibernate.processor.HibernateProcessor;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public final class ClassWriter {
    private ClassWriter() {
    }

    public static void writeFile(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        try {
            String metaModelPackage = entity.getPackageName();
            String body = ClassWriter.generateBody(entity, context).toString();
            JavaFileObject fo = context.getProcessingEnvironment().getFiler().createSourceFile(ClassWriter.getFullyQualifiedClassName(entity, metaModelPackage), entity.getElement());
            OutputStream os = fo.openOutputStream();
            PrintWriter pw = new PrintWriter(os);
            if (!metaModelPackage.isEmpty()) {
                pw.println("package " + metaModelPackage + ";");
                pw.println();
            }
            pw.println(entity.generateImports());
            pw.println(body);
            pw.flush();
            pw.close();
        }
        catch (FilerException filerEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem with Filer: " + filerEx.getMessage());
        }
        catch (IOException ioEx) {
            context.logMessage(Diagnostic.Kind.ERROR, "Problem opening file to write MetaModel for " + entity.getSimpleName() + ": " + ioEx.getMessage());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized StringBuffer generateBody(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            if (context.addDependentAnnotation() && entity.isInjectable()) {
                pw.println(ClassWriter.writeScopeAnnotation(entity));
            }
            if (entity.getElement() instanceof TypeElement && !entity.isInjectable()) {
                pw.println(ClassWriter.writeStaticMetaModelAnnotation(entity));
            }
            if (context.addGeneratedAnnotation()) {
                pw.println(ClassWriter.writeGeneratedAnnotation(entity, context));
            }
            if (context.addSuppressWarningsAnnotation()) {
                pw.println(ClassWriter.writeSuppressWarnings(context));
            }
            entity.inheritedAnnotations().forEach(pw::println);
            ClassWriter.printClassDeclaration(entity, pw);
            pw.println();
            List<MetaAttribute> members = entity.getMembers();
            for (MetaAttribute metaMember : members) {
                if (!metaMember.hasStringAttribute()) continue;
                pw.println("\t" + metaMember.getAttributeNameDeclarationString());
            }
            pw.println();
            for (MetaAttribute metaMember : members) {
                if (!metaMember.hasTypedAttribute()) continue;
                metaMember.getAttributeDeclarationString().lines().forEach(line -> {
                    pw.println("\t" + line);
                    if (line.trim().startsWith("@Override")) {
                        metaMember.inheritedAnnotations().forEach(x -> {
                            pw.print('\t');
                            pw.println(x);
                        });
                    }
                });
            }
            pw.println();
            pw.println("}");
            StringBuffer stringBuffer = sw.getBuffer();
            return stringBuffer;
        }
    }

    private static void printClassDeclaration(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized PrintWriter pw) {
        pw.print("public ");
        if (!entity.isImplementation() && !entity.isJakartaDataStyle()) {
            pw.print("abstract ");
        }
        pw.print(entity.isJakartaDataStyle() ? "interface " : "class ");
        pw.print(ClassWriter.getGeneratedClassName(entity));
        String superClassName = entity.getSupertypeName();
        if (superClassName != null) {
            pw.print(" extends " + ClassWriter.getGeneratedSuperclassName(entity, superClassName));
        }
        if (entity.isImplementation()) {
            pw.print(entity.getElement().getKind() == ElementKind.CLASS ? " extends " : " implements ");
            pw.print(entity.getSimpleName());
        }
        pw.println(" {");
    }

    private static @UnknownKeyFor @NonNull @Initialized String getFullyQualifiedClassName(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized String metaModelPackage) {
        Object fullyQualifiedClassName = "";
        if (!metaModelPackage.isEmpty()) {
            fullyQualifiedClassName = (String)fullyQualifiedClassName + metaModelPackage + ".";
        }
        fullyQualifiedClassName = (String)fullyQualifiedClassName + ClassWriter.getGeneratedClassName(entity);
        return fullyQualifiedClassName;
    }

    private static @UnknownKeyFor @NonNull @Initialized String getGeneratedClassName(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        String className = entity.getSimpleName();
        return entity.isJakartaDataStyle() ? "_" + className : className + "_";
    }

    private static @UnknownKeyFor @NonNull @Initialized String getGeneratedSuperclassName(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized String superClassName) {
        if (entity.isJakartaDataStyle()) {
            int lastDot = superClassName.lastIndexOf(46);
            if (lastDot < 0) {
                return "_" + superClassName;
            }
            return superClassName.substring(0, lastDot + 1) + "_" + superClassName.substring(lastDot + 1);
        }
        return superClassName + "_";
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeGeneratedAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity, @UnknownKeyFor @NonNull @Initialized Context context) {
        StringBuilder generatedAnnotation = new StringBuilder();
        generatedAnnotation.append("@").append(entity.importType("jakarta.annotation.Generated")).append("(");
        if (context.addGeneratedDate()) {
            generatedAnnotation.append("value = ");
        }
        generatedAnnotation.append("\"").append(HibernateProcessor.class.getName()).append("\"");
        if (context.addGeneratedDate()) {
            generatedAnnotation.append(", date = ").append("\"").append(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(OffsetDateTime.now())).append("\"");
        }
        generatedAnnotation.append(")");
        return generatedAnnotation.toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeSuppressWarnings(@UnknownKeyFor @NonNull @Initialized Context context) {
        StringBuilder annotation = new StringBuilder("@SuppressWarnings({");
        String[] warnings = context.getSuppressedWarnings();
        for (int i = 0; i < warnings.length; ++i) {
            if (i > 0) {
                annotation.append(", ");
            }
            annotation.append('\"').append(warnings[i]).append('\"');
        }
        return annotation.append("})").toString();
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeScopeAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        return "@" + entity.importType(entity.scope());
    }

    private static @UnknownKeyFor @NonNull @Initialized String writeStaticMetaModelAnnotation(@UnknownKeyFor @NonNull @Initialized Metamodel entity) {
        String annotation = entity.isJakartaDataStyle() ? "jakarta.data.metamodel.StaticMetamodel" : "jakarta.persistence.metamodel.StaticMetamodel";
        return "@" + entity.importType(annotation) + "(" + entity.getSimpleName() + ".class)";
    }
}

