/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.enhance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.hibernate.bytecode.enhance.spi.DefaultEnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.enhance.spi.UnloadedClass;
import org.hibernate.bytecode.enhance.spi.UnloadedField;
import org.hibernate.bytecode.internal.BytecodeProviderInitiator;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementSpec;

public class EnhancementHelper {
    private static final Logger logger = Logging.getLogger(EnhancementHelper.class);

    public static void enhance(DirectoryProperty classesDirectoryProperty, ClassLoader classLoader, HibernateOrmSpec ormDsl) {
        Directory classesDirectory = (Directory)classesDirectoryProperty.get();
        File classesDir = classesDirectory.getAsFile();
        EnhancementSpec enhancementDsl = (EnhancementSpec)ormDsl.getEnhancement().get();
        List classesToEnhance = (List)enhancementDsl.getClassNames().get();
        if (!((Boolean)enhancementDsl.getEnableLazyInitialization().get()).booleanValue()) {
            logger.warn("The 'enableLazyInitialization' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning");
        }
        if (((Boolean)enhancementDsl.getEnableAssociationManagement().get()).booleanValue()) {
            logger.warn("Management of bidirectional association persistent attributes is deprecated and will be removed. Set the value to 'false' to get rid of this warning");
        }
        if (!((Boolean)enhancementDsl.getEnableDirtyTracking().get()).booleanValue()) {
            logger.warn("The 'enableDirtyTracking' configuration is deprecated and will be removed. Set the value to 'true' to get rid of this warning");
        }
        if (((Boolean)enhancementDsl.getEnableExtendedEnhancement().get()).booleanValue()) {
            logger.warn("Extended enhancement is deprecated and will be removed. Set the value to 'false' to get rid of this warning");
        }
        Enhancer enhancer = EnhancementHelper.generateEnhancer(classLoader, enhancementDsl);
        EnhancementHelper.discoverTypes(classesDir, classesDir, enhancer, ormDsl.getFileOperations());
        EnhancementHelper.doEnhancement(classesDir, classesDir, enhancer, ormDsl.getFileOperations(), classesToEnhance);
    }

    private static void discoverTypes(File classesDir, File dir, Enhancer enhancer, FileOperations fileOperations) {
        for (File subLocation : dir.listFiles()) {
            if (subLocation.isDirectory()) {
                EnhancementHelper.discoverTypes(classesDir, subLocation, enhancer, fileOperations);
                continue;
            }
            if (!subLocation.isFile() || !subLocation.getName().endsWith(".class")) continue;
            String className = Helper.determineClassName(classesDir, subLocation);
            long lastModified = subLocation.lastModified();
            EnhancementHelper.discoverTypes(subLocation, className, enhancer);
            boolean timestampReset = subLocation.setLastModified(lastModified);
            if (timestampReset) continue;
            logger.debug("`{}`.setLastModified failed", (Object)fileOperations.relativePath((Object)subLocation));
        }
    }

    private static void doEnhancement(File classesDir, File dir, Enhancer enhancer, FileOperations fileOperations, List<String> classesToEnhance) {
        for (File subLocation : dir.listFiles()) {
            if (subLocation.isDirectory()) {
                EnhancementHelper.doEnhancement(classesDir, subLocation, enhancer, fileOperations, classesToEnhance);
                continue;
            }
            if (!subLocation.isFile() || !subLocation.getName().endsWith(".class")) continue;
            String className = Helper.determineClassName(classesDir, subLocation);
            long lastModified = subLocation.lastModified();
            if (classesToEnhance.size() != 0 && !classesToEnhance.contains(className)) continue;
            EnhancementHelper.enhance(subLocation, className, enhancer);
            boolean timestampReset = subLocation.setLastModified(lastModified);
            if (timestampReset) continue;
            logger.debug("`{}`.setLastModified failed", (Object)fileOperations.relativePath((Object)subLocation));
        }
    }

    private static void discoverTypes(File javaClassFile, String className, Enhancer enhancer) {
        try {
            enhancer.discoverTypes(className, Files.readAllBytes(javaClassFile.toPath()));
            logger.info("Successfully discovered types for class : " + className);
        }
        catch (Exception e) {
            throw new GradleException("Unable to discover types for class : " + className, (Throwable)e);
        }
    }

    private static void enhance(File javaClassFile, String className, Enhancer enhancer) {
        byte[] enhancedBytecode = EnhancementHelper.doEnhancement(javaClassFile, className, enhancer);
        if (enhancedBytecode != null) {
            EnhancementHelper.writeOutEnhancedClass(enhancedBytecode, javaClassFile);
            logger.info("Successfully enhanced class : " + className);
        } else {
            logger.info("Skipping class : " + className);
        }
    }

    private static byte[] doEnhancement(File javaClassFile, String className, Enhancer enhancer) {
        try {
            return enhancer.enhance(className, Files.readAllBytes(javaClassFile.toPath()));
        }
        catch (Exception e) {
            throw new GradleException("Unable to enhance class : " + className, (Throwable)e);
        }
    }

    public static Enhancer generateEnhancer(final ClassLoader classLoader, final EnhancementSpec enhancementDsl) {
        DefaultEnhancementContext enhancementContext = new DefaultEnhancementContext(){

            public ClassLoader getLoadingClassLoader() {
                return classLoader;
            }

            public boolean doBiDirectionalAssociationManagement(UnloadedField field) {
                return (Boolean)enhancementDsl.getEnableAssociationManagement().get();
            }

            public boolean doDirtyCheckingInline(UnloadedClass classDescriptor) {
                return (Boolean)enhancementDsl.getEnableDirtyTracking().get();
            }

            public boolean hasLazyLoadableAttributes(UnloadedClass classDescriptor) {
                return (Boolean)enhancementDsl.getEnableLazyInitialization().get();
            }

            public boolean isLazyLoadable(UnloadedField field) {
                return (Boolean)enhancementDsl.getEnableLazyInitialization().get();
            }

            public boolean doExtendedEnhancement(UnloadedClass classDescriptor) {
                return (Boolean)enhancementDsl.getEnableExtendedEnhancement().get();
            }
        };
        return BytecodeProviderInitiator.buildDefaultBytecodeProvider().getEnhancer((EnhancementContext)enhancementContext);
    }

    private static void writeOutEnhancedClass(byte[] enhancedBytecode, File file) {
        try {
            if (file.delete()) {
                if (!file.createNewFile()) {
                    logger.error("Unable to recreate class file : " + file.getAbsolutePath());
                }
            } else {
                logger.error("Unable to delete class file : " + file.getAbsolutePath());
            }
        }
        catch (IOException e) {
            logger.warn("Problem preparing class file for writing out enhancements [" + file.getAbsolutePath() + "]");
        }
        try {
            Files.write(file.toPath(), enhancedBytecode, new OpenOption[0]);
        }
        catch (FileNotFoundException e) {
            throw new GradleException("Error opening class file for writing : " + file.getAbsolutePath(), (Throwable)e);
        }
        catch (IOException e) {
            throw new GradleException("Error writing enhanced class to file [" + file.getAbsolutePath() + "]", (Throwable)e);
        }
    }

    private EnhancementHelper() {
    }
}

