/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.misc;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.orm.tooling.gradle.misc.OriginImpl;
import org.hibernate.orm.tooling.gradle.misc.TransformationNaming;
import org.hibernate.service.ServiceRegistry;

@CacheableTask
public abstract class TransformHbmXmlTask
extends SourceTask {
    private final TransformationNaming renaming;
    private final Property<String> targetDatabaseName;
    private final Property<UnsupportedFeatureHandling> unsupportedFeatures;
    private final Property<Boolean> deleteHbmFiles;
    private final DirectoryProperty outputDirectory = this.getProject().getObjects().directoryProperty();

    public TransformHbmXmlTask() {
        this.renaming = new TransformationNaming(this.getProject().getObjects());
        this.targetDatabaseName = this.getProject().getObjects().property(String.class);
        this.targetDatabaseName.convention((Object)"H2");
        this.unsupportedFeatures = this.getProject().getObjects().property(UnsupportedFeatureHandling.class);
        this.unsupportedFeatures.convention((Object)UnsupportedFeatureHandling.ERROR);
        this.deleteHbmFiles = this.getProject().getObjects().property(Boolean.class);
        this.deleteHbmFiles.convention((Object)false);
    }

    @Nested
    public TransformationNaming getRenaming() {
        return this.renaming;
    }

    @Input
    public Property<String> getTargetDatabaseName() {
        return this.targetDatabaseName;
    }

    @Input
    public Property<UnsupportedFeatureHandling> getUnsupportedFeatures() {
        return this.unsupportedFeatures;
    }

    @Input
    public Property<Boolean> getDeleteHbmFiles() {
        return this.deleteHbmFiles;
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void transformFiles() {
        MappingBinder mappingBinder = new MappingBinder(MappingBinder.class.getClassLoader()::getResourceAsStream, (UnsupportedFeatureHandling)this.unsupportedFeatures.getOrElse((Object)UnsupportedFeatureHandling.ERROR));
        ArrayList<Binding<JaxbHbmHibernateMapping>> hbmBindings = new ArrayList<Binding<JaxbHbmHibernateMapping>>();
        this.getSource().forEach(hbmXmlFile -> {
            OriginImpl origin = new OriginImpl((File)hbmXmlFile);
            Binding<JaxbHbmHibernateMapping> hbmBinding = this.bindMapping(mappingBinder, (File)hbmXmlFile, origin);
            hbmBindings.add(hbmBinding);
        });
        try (StandardServiceRegistry serviceRegistry = new StandardServiceRegistryBuilder().clearSettings().applySetting("jakarta.persistence.database-product-name", this.targetDatabaseName.get()).applySetting("hibernate.boot.allow_jdbc_metadata_access", (Object)false).build();){
            this.performTransformation(hbmBindings, mappingBinder, serviceRegistry);
        }
    }

    private void performTransformation(List<Binding<JaxbHbmHibernateMapping>> hbmBindings, MappingBinder mappingBinder, StandardServiceRegistry serviceRegistry) {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        hbmBindings.forEach(arg_0 -> ((MetadataSources)metadataSources).addHbmXmlBinding(arg_0));
        List transformedBindings = HbmXmlTransformer.transform(hbmBindings, (MetadataImplementor)((MetadataImplementor)metadataSources.buildMetadata()), (UnsupportedFeatureHandling)((UnsupportedFeatureHandling)this.unsupportedFeatures.get()));
        for (int i = 0; i < hbmBindings.size(); ++i) {
            Marshaller marshaller;
            boolean deleted;
            Binding<JaxbHbmHibernateMapping> hbmBinding = hbmBindings.get(i);
            Binding transformedBinding = (Binding)transformedBindings.get(i);
            OriginImpl origin = (OriginImpl)hbmBinding.getOrigin();
            File hbmXmlFile = origin.getHbmXmlFile();
            if (((Boolean)this.deleteHbmFiles.getOrElse((Object)false)).booleanValue() && !(deleted = hbmXmlFile.delete())) {
                this.getProject().getLogger().warn("Unable to delete hbm.xml file `{}`", (Object)hbmXmlFile.getAbsoluteFile());
            }
            String copyName = this.determineCopyName(hbmXmlFile);
            File copyFile = this.determineCopyFile(copyName, hbmXmlFile);
            copyFile.getParentFile().mkdirs();
            try {
                marshaller = mappingBinder.mappingJaxbContext().createMarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException("Unable to create JAXB Marshaller", e);
            }
            try {
                marshaller.marshal(transformedBinding.getRoot(), copyFile);
                continue;
            }
            catch (JAXBException e) {
                throw new RuntimeException("Unable to marshall mapping JAXB representation to file `" + copyFile.getAbsolutePath() + "`", e);
            }
        }
    }

    private Binding<JaxbHbmHibernateMapping> bindMapping(MappingBinder mappingBinder, File hbmXmlFile, Origin origin) {
        Binding binding;
        FileInputStream fileStream = new FileInputStream(hbmXmlFile);
        try {
            binding = mappingBinder.bind((InputStream)fileStream, origin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getProject().getLogger().warn("Unable to open hbm.xml file `" + hbmXmlFile.getAbsolutePath() + "` for transformation", (Throwable)e);
                return null;
            }
        }
        fileStream.close();
        return binding;
    }

    private File determineCopyFile(String copyName, File hbmXmlFile) {
        if (this.outputDirectory.isPresent()) {
            return ((Directory)this.outputDirectory.get()).file(copyName).getAsFile();
        }
        return new File(hbmXmlFile.getParentFile(), copyName);
    }

    private String determineCopyName(File hbmXmlFile) {
        String extension;
        String suffix;
        String hbmXmlFileExtension;
        String copyBaseName;
        String hbmXmlFileName = hbmXmlFile.getName();
        if (this.renaming.areNoneDefined()) {
            return hbmXmlFileName;
        }
        int legacyConventionExtensionIndex = hbmXmlFileName.indexOf(".hbm.xml");
        if (legacyConventionExtensionIndex > 0) {
            copyBaseName = hbmXmlFileName.substring(0, legacyConventionExtensionIndex);
            hbmXmlFileExtension = ".hbm.xml";
        } else {
            int extensionIndex = hbmXmlFileName.lastIndexOf(".'");
            if (extensionIndex > 0) {
                copyBaseName = hbmXmlFileName.substring(0, legacyConventionExtensionIndex);
                hbmXmlFileExtension = hbmXmlFileName.substring(extensionIndex + 1);
            } else {
                copyBaseName = hbmXmlFileName;
                hbmXmlFileExtension = null;
            }
        }
        Object copyName = copyBaseName;
        String prefix = (String)this.renaming.getPrefix().getOrNull();
        if (prefix != null) {
            copyName = (String)this.renaming.getPrefix().get() + (String)copyName;
        }
        if ((suffix = (String)this.renaming.getSuffix().getOrNull()) != null) {
            copyName = (String)copyName + suffix;
        }
        if ((extension = (String)this.renaming.getExtension().getOrNull()) != null) {
            copyName = (String)copyName + ".";
            copyName = (String)copyName + extension;
        } else if (hbmXmlFileExtension != null) {
            copyName = (String)copyName + ".";
            copyName = (String)copyName + hbmXmlFileExtension;
        }
        return copyName;
    }
}

