/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle.misc;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmHibernateMapping;
import org.hibernate.boot.jaxb.hbm.transform.HbmXmlTransformer;
import org.hibernate.boot.jaxb.hbm.transform.UnsupportedFeatureHandling;
import org.hibernate.boot.jaxb.internal.MappingBinder;
import org.hibernate.boot.jaxb.mapping.spi.JaxbEntityMappingsImpl;
import org.hibernate.boot.jaxb.spi.Binding;
import org.hibernate.orm.tooling.gradle.misc.TransformationNaming;

public abstract class TransformHbmXmlTask
extends SourceTask {
    private final Property<TransformationNaming> renaming;
    private final Property<UnsupportedFeatureHandling> unsupportedFeatures;
    private final Property<Boolean> deleteHbmFiles;
    private final DirectoryProperty outputDirectory = this.getProject().getObjects().directoryProperty();

    public TransformHbmXmlTask() {
        this.renaming = this.getProject().getObjects().property(TransformationNaming.class);
        this.renaming.set((Object)new TransformationNaming(this.getProject().getObjects()));
        this.unsupportedFeatures = this.getProject().getObjects().property(UnsupportedFeatureHandling.class);
        this.unsupportedFeatures.convention((Object)UnsupportedFeatureHandling.ERROR);
        this.deleteHbmFiles = this.getProject().getObjects().property(Boolean.class);
        this.deleteHbmFiles.convention((Object)false);
    }

    @Nested
    public Property<TransformationNaming> getRenaming() {
        return this.renaming;
    }

    @Input
    public Property<UnsupportedFeatureHandling> getUnsupportedFeatures() {
        return this.unsupportedFeatures;
    }

    @Input
    public Property<Boolean> getDeleteHbmFiles() {
        return this.deleteHbmFiles;
    }

    @OutputDirectory
    public DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @TaskAction
    public void transformFiles() {
        Marshaller marshaller;
        MappingBinder mappingBinder = new MappingBinder(MappingBinder.class.getClassLoader()::getResourceAsStream, (UnsupportedFeatureHandling)this.unsupportedFeatures.getOrElse((Object)UnsupportedFeatureHandling.ERROR));
        try {
            marshaller = mappingBinder.mappingJaxbContext().createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to create JAXB Marshaller", e);
        }
        this.getSource().forEach(hbmXmlFile -> this.transformFile(mappingBinder, marshaller, (File)hbmXmlFile));
    }

    private void transformFile(MappingBinder mappingBinder, Marshaller marshaller, File hbmXmlFile) {
        boolean deleted;
        Origin origin = new Origin(SourceType.FILE, hbmXmlFile.getAbsolutePath());
        Binding<JaxbHbmHibernateMapping> binding = this.bindMapping(mappingBinder, hbmXmlFile, origin);
        if (binding == null) {
            return;
        }
        if (((Boolean)this.deleteHbmFiles.getOrElse((Object)false)).booleanValue() && !(deleted = hbmXmlFile.delete())) {
            this.getProject().getLogger().warn("Unable to delete hbm.xml file `{}`", (Object)hbmXmlFile.getAbsoluteFile());
        }
        HbmXmlTransformer.Options transformationOptions = () -> this.unsupportedFeatures.get();
        JaxbEntityMappingsImpl transformed = HbmXmlTransformer.transform((JaxbHbmHibernateMapping)((JaxbHbmHibernateMapping)binding.getRoot()), (Origin)origin, (HbmXmlTransformer.Options)transformationOptions);
        String copyName = this.determineCopyName(hbmXmlFile);
        File copyFile = this.determineCopyFile(copyName, hbmXmlFile);
        copyFile.getParentFile().mkdirs();
        try {
            marshaller.marshal((Object)transformed, copyFile);
        }
        catch (JAXBException e) {
            throw new RuntimeException("Unable to marshall mapping JAXB representation to file `" + copyFile.getAbsolutePath() + "`", e);
        }
    }

    private Binding<JaxbHbmHibernateMapping> bindMapping(MappingBinder mappingBinder, File hbmXmlFile, Origin origin) {
        Binding binding;
        FileInputStream fileStream = new FileInputStream(hbmXmlFile);
        try {
            binding = mappingBinder.bind((InputStream)fileStream, origin);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                this.getProject().getLogger().warn("Unable to open hbm.xml file `" + hbmXmlFile.getAbsolutePath() + "` for transformation", (Throwable)e);
                return null;
            }
        }
        fileStream.close();
        return binding;
    }

    private File determineCopyFile(String copyName, File hbmXmlFile) {
        if (this.outputDirectory.isPresent()) {
            return ((Directory)this.outputDirectory.get()).file(copyName).getAsFile();
        }
        return new File(hbmXmlFile.getParentFile(), copyName);
    }

    private String determineCopyName(File hbmXmlFile) {
        String extension;
        String suffix;
        String hbmXmlFileExtension;
        String copyBaseName;
        String hbmXmlFileName = hbmXmlFile.getName();
        if (!this.renaming.isPresent()) {
            return hbmXmlFileName;
        }
        TransformationNaming renaming = (TransformationNaming)this.renaming.get();
        if (renaming.areNoneDefined()) {
            return hbmXmlFileName;
        }
        int legacyConventionExtensionIndex = hbmXmlFileName.indexOf(".hbm.xml");
        if (legacyConventionExtensionIndex > 0) {
            copyBaseName = hbmXmlFileName.substring(0, legacyConventionExtensionIndex);
            hbmXmlFileExtension = ".hbm.xml";
        } else {
            int extensionIndex = hbmXmlFileName.lastIndexOf(".'");
            if (extensionIndex > 0) {
                copyBaseName = hbmXmlFileName.substring(0, legacyConventionExtensionIndex);
                hbmXmlFileExtension = hbmXmlFileName.substring(extensionIndex + 1);
            } else {
                copyBaseName = hbmXmlFileName;
                hbmXmlFileExtension = null;
            }
        }
        Object copyName = copyBaseName;
        String prefix = (String)renaming.getPrefix().getOrNull();
        if (prefix != null) {
            copyName = (String)renaming.getPrefix().get() + (String)copyName;
        }
        if ((suffix = (String)renaming.getSuffix().getOrNull()) != null) {
            copyName = (String)copyName + suffix;
        }
        if ((extension = (String)renaming.getExtension().getOrNull()) != null) {
            copyName = (String)copyName + ".";
            copyName = (String)copyName + extension;
        } else if (hbmXmlFileExtension != null) {
            copyName = (String)copyName + ".";
            copyName = (String)copyName + hbmXmlFileExtension;
        }
        return copyName;
    }
}

