/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import org.gradle.api.GradleException;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;

public class HibernateVersion {
    public static volatile String version = HibernateVersion.determineHibernateVersion();

    /*
     * Enabled aggressive exception aggregation
     */
    private static String determineHibernateVersion() {
        URL versionFileUrl = HibernateVersion.findVersionFile();
        try (InputStream inputStream = versionFileUrl.openStream();){
            String string;
            try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream);){
                string = new LineNumberReader(inputStreamReader).readLine();
            }
            return string;
        }
        catch (IOException e) {
            throw new GradleException("Unable to read `META-INF/hibernate-orm.version` resource");
        }
    }

    private static URL findVersionFile() {
        URL badGunsAndRoses = HibernateOrmSpec.class.getClassLoader().getResource("META-INF/hibernate-orm.version");
        if (badGunsAndRoses != null) {
            return badGunsAndRoses;
        }
        URL goodGunsAndRoses = HibernateOrmSpec.class.getClassLoader().getResource("/META-INF/hibernate-orm.version");
        return goodGunsAndRoses;
    }
}

