/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.lang.reflect.Method;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JvmEcosystemPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.JavaCompile;
import org.hibernate.orm.tooling.gradle.Helper;
import org.hibernate.orm.tooling.gradle.HibernateOrmSpec;
import org.hibernate.orm.tooling.gradle.HibernateVersion;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementHelper;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationTask;

public class HibernateOrmPlugin
implements Plugin<Project> {
    public void apply(Project project) {
        project.getPlugins().apply(JvmEcosystemPlugin.class);
        project.getLogger().debug("Adding Hibernate extensions to the build [{}]", (Object)project.getPath());
        HibernateOrmSpec ormDsl = (HibernateOrmSpec)project.getExtensions().create("hibernate", HibernateOrmSpec.class, new Object[]{project});
        this.prepareEnhancement(ormDsl, project);
        this.prepareModelGen(ormDsl, project);
        this.prepareHbmTransformation(ormDsl, project);
        project.getDependencies().add("implementation", (Object)ormDsl.getUseSameVersion().map(use -> use != false ? "org.hibernate.orm:hibernate-core:" + HibernateVersion.version : null));
    }

    private void prepareEnhancement(final HibernateOrmSpec ormDsl, final Project project) {
        project.getGradle().getTaskGraph().whenReady(graph -> {
            if (!ormDsl.isEnhancementEnabled()) {
                return;
            }
            final SourceSet sourceSet = (SourceSet)ormDsl.getSourceSet().get();
            Set languages = (Set)ormDsl.getLanguages().getOrNull();
            if (languages == null) {
                return;
            }
            for (String language : languages) {
                String languageCompileTaskName = sourceSet.getCompileTaskName(language);
                final Task languageCompileTask = (Task)project.getTasks().findByName(languageCompileTaskName);
                if (languageCompileTask == null) continue;
                languageCompileTask.doLast((Action)new Action<Task>(){

                    public void execute(Task t) {
                        try {
                            Method getDestinationDirectory = languageCompileTask.getClass().getMethod("getDestinationDirectory", new Class[0]);
                            DirectoryProperty classesDirectory = (DirectoryProperty)getDestinationDirectory.invoke((Object)languageCompileTask, new Object[0]);
                            ClassLoader classLoader = Helper.toClassLoader(sourceSet, project);
                            EnhancementHelper.enhance(classesDirectory, classLoader, ormDsl, project);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        });
    }

    private void prepareModelGen(HibernateOrmSpec ormDsl, Project project) {
        TaskProvider modelCompileTaskRef = project.getTasks().register("compileJpaMetamodel", JavaCompile.class, modelCompileTask -> {
            modelCompileTask.onlyIf(t -> ormDsl.isMetamodelGenerationEnabled());
            modelCompileTask.setGroup("hibernate");
            modelCompileTask.setDescription("Compiles the JPA static metamodel generated by `generateJpaMetamodel`");
        });
        project.getTasks().register("generateJpaMetamodel", JpaMetamodelGenerationTask.class, genTask -> {
            genTask.onlyIf(t -> ormDsl.isMetamodelGenerationEnabled());
            if (!ormDsl.isMetamodelGenerationEnabled()) {
                return;
            }
            genTask.injectSourceSet((Provider<SourceSet>)ormDsl.getSourceSet());
            genTask.getGenerationOutputDirectory().set((Provider)ormDsl.getJpaMetamodel().getGenerationOutputDirectory());
            genTask.getApplyGeneratedAnnotation().convention(ormDsl.getJpaMetamodel().getApplyGeneratedAnnotation());
            genTask.getSuppressions().convention(ormDsl.getJpaMetamodel().getSuppressions());
            JavaCompile modelCompileTask = (JavaCompile)modelCompileTaskRef.get();
            SourceSet sourceSet = (SourceSet)ormDsl.getSourceSet().get();
            sourceSet.getAllSource().minus((FileCollection)sourceSet.getAllSource()).forEach(dir -> {
                String language = dir.getName();
                String languageCompileTaskName = sourceSet.getCompileTaskName(language);
                AbstractCompile languageCompileTask = (AbstractCompile)project.getTasks().getByName(languageCompileTaskName);
                genTask.dependsOn(new Object[]{languageCompileTask});
                modelCompileTask.setSourceCompatibility(languageCompileTask.getSourceCompatibility());
                modelCompileTask.setTargetCompatibility(languageCompileTask.getTargetCompatibility());
                modelCompileTask.finalizedBy(new Object[]{modelCompileTask});
            });
            genTask.dependsOn(new Object[]{sourceSet.getProcessResourcesTaskName()});
            genTask.finalizedBy(new Object[]{modelCompileTask});
            modelCompileTask.dependsOn(new Object[]{genTask});
            modelCompileTask.source(new Object[]{project.files(new Object[]{ormDsl.getJpaMetamodel().getGenerationOutputDirectory()})});
            modelCompileTask.getDestinationDirectory().set((Provider)ormDsl.getJpaMetamodel().getCompileOutputDirectory());
            FileCollection metamodelCompileClasspath = project.getConfigurations().getByName("runtimeClasspath").plus(sourceSet.getCompileClasspath()).plus(sourceSet.getRuntimeClasspath());
            if (((Boolean)ormDsl.getJpaMetamodel().getApplyGeneratedAnnotation().getOrElse((Object)true)).booleanValue()) {
                Dependency jakartaAnnotationsDep = project.getDependencies().create((Object)"jakarta.annotation:jakarta.annotation-api:2.0.0");
                metamodelCompileClasspath = metamodelCompileClasspath.plus((FileCollection)project.getConfigurations().detachedConfiguration(new Dependency[]{jakartaAnnotationsDep}));
            }
            modelCompileTask.setClasspath(metamodelCompileClasspath);
        });
    }

    private void prepareHbmTransformation(HibernateOrmSpec ormDsl, Project project) {
    }
}

