/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.hibernate.orm.tooling.gradle.enhance.EnhancementSpec;
import org.hibernate.orm.tooling.gradle.metamodel.JpaMetamodelGenerationSpec;

public abstract class HibernateOrmSpec
implements ExtensionAware {
    public static final String HIBERNATE = "hibernate";
    public static final String DSL_NAME = "hibernate";
    private final Project project;
    private EnhancementSpec enhancementDsl;
    private JpaMetamodelGenerationSpec jpaMetamodelDsl;
    private final Property<Boolean> useSameVersion;
    private final Property<SourceSet> sourceSet;
    private final Provider<EnhancementSpec> enhancementDslAccess;
    private final Provider<JpaMetamodelGenerationSpec> jpaMetamodelDslAccess;

    @Inject
    public HibernateOrmSpec(Project project) {
        this.project = project;
        this.useSameVersion = project.getObjects().property(Boolean.class);
        this.useSameVersion.convention((Object)true);
        this.sourceSet = project.getObjects().property(SourceSet.class);
        this.sourceSet.convention((Object)HibernateOrmSpec.mainSourceSet(project));
        this.enhancementDslAccess = project.provider(() -> this.enhancementDsl);
        this.jpaMetamodelDslAccess = project.provider(() -> this.jpaMetamodelDsl);
    }

    private static SourceSet mainSourceSet(Project project) {
        return HibernateOrmSpec.resolveSourceSet("main", project);
    }

    private static SourceSet resolveSourceSet(String name, Project project) {
        JavaPluginExtension javaPluginExtension = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        return (SourceSet)javaPluginExtension.getSourceSets().getByName(name);
    }

    public Property<Boolean> getUseSameVersion() {
        return this.useSameVersion;
    }

    public void setUseSameVersion(boolean value) {
        this.useSameVersion.set((Object)value);
    }

    public void useSameVersion() {
        this.useSameVersion.set((Object)true);
    }

    public Property<SourceSet> getSourceSet() {
        return this.sourceSet;
    }

    public void setSourceSet(String name) {
        this.setSourceSet(HibernateOrmSpec.resolveSourceSet(name, this.project));
    }

    public void setSourceSet(SourceSet sourceSet) {
        this.sourceSet.set((Object)sourceSet);
    }

    public void sourceSet(String name) {
        this.setSourceSet(HibernateOrmSpec.resolveSourceSet(name, this.project));
    }

    public void sourceSet(SourceSet sourceSet) {
        this.setSourceSet(sourceSet);
    }

    public EnhancementSpec getEnhancement() {
        if (this.enhancementDsl == null) {
            this.enhancementDsl = (EnhancementSpec)this.getExtensions().create("enhancement", EnhancementSpec.class, new Object[]{this, this.project});
        }
        return this.enhancementDsl;
    }

    public Provider<EnhancementSpec> getEnhancementDslAccess() {
        return this.enhancementDslAccess;
    }

    public boolean isEnhancementEnabled() {
        return this.enhancementDsl != null;
    }

    public void enhancement(Action<EnhancementSpec> action) {
        action.execute((Object)this.getEnhancement());
    }

    public JpaMetamodelGenerationSpec getJpaMetamodel() {
        if (this.jpaMetamodelDsl == null) {
            this.jpaMetamodelDsl = (JpaMetamodelGenerationSpec)this.getExtensions().create("jpaMetamodel", JpaMetamodelGenerationSpec.class, new Object[]{this, this.project});
        }
        return this.jpaMetamodelDsl;
    }

    public Provider<JpaMetamodelGenerationSpec> getJpaMetamodelDslAccess() {
        return this.jpaMetamodelDslAccess;
    }

    public boolean isMetamodelGenerationEnabled() {
        return this.jpaMetamodelDsl != null;
    }

    public void jpaMetamodel(Action<JpaMetamodelGenerationSpec> action) {
        action.execute((Object)this.getJpaMetamodel());
    }

    public abstract ExtensionContainer getExtensions();
}

