/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.orm.tooling.gradle;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class Helper {
    public static String determineCompileSourceSetName(String name) {
        return Helper.determineCompileNameParts(name)[0];
    }

    public static String[] determineCompileNameParts(String name) {
        StringBuilder firstPart = null;
        StringBuilder secondPart = null;
        boolean processingFirstPart = false;
        boolean processingSecondPart = false;
        char[] nameChars = name.toCharArray();
        for (int i = 0; i < nameChars.length; ++i) {
            char nameChar = nameChars[i];
            if (processingFirstPart) {
                if (Character.isUpperCase(nameChar)) {
                    processingFirstPart = false;
                    processingSecondPart = true;
                    secondPart = new StringBuilder(String.valueOf(Character.toLowerCase(nameChar)));
                    continue;
                }
                firstPart.append(nameChar);
                continue;
            }
            if (processingSecondPart) {
                if (Character.isUpperCase(nameChar)) {
                    throw new RuntimeException("Unexpected compilation task name : " + name);
                }
                secondPart.append(nameChar);
                continue;
            }
            if (!Character.isUpperCase(nameChar)) continue;
            processingFirstPart = true;
            firstPart = new StringBuilder(String.valueOf(Character.toLowerCase(nameChar)));
        }
        if (firstPart == null) {
            throw new RuntimeException("Unexpected compilation task name : " + name);
        }
        if (secondPart == null) {
            return new String[]{"main", firstPart.toString()};
        }
        return new String[]{firstPart.toString(), secondPart.toString()};
    }

    public static ClassLoader toClassLoader(FileCollection directories) {
        Set files = directories.getFiles();
        URL[] urls = new URL[files.size()];
        int index = 0;
        for (File classesDir : files) {
            URI classesDirUri = classesDir.toURI();
            try {
                urls[index] = classesDirUri.toURL();
            }
            catch (MalformedURLException e) {
                throw new GradleException("Unable to resolve classpath entry to URL : " + classesDir.getAbsolutePath(), (Throwable)e);
            }
            ++index;
        }
        return new URLClassLoader(urls, Enhancer.class.getClassLoader());
    }

    public static ClassLoader toClassLoader(File classesDir) {
        URI classesDirUri = classesDir.toURI();
        try {
            URL url = classesDirUri.toURL();
            return new URLClassLoader(new URL[]{url}, Enhancer.class.getClassLoader());
        }
        catch (MalformedURLException e) {
            throw new GradleException("Unable to resolve classpath entry to URL : " + classesDir.getAbsolutePath(), (Throwable)e);
        }
    }

    public static String determineClassName(File root, File javaClassFile) {
        Path relativeClassPath = root.toPath().relativize(javaClassFile.toPath());
        String relativeClassPathString = relativeClassPath.toString();
        String classNameBase = relativeClassPathString.substring(0, relativeClassPathString.length() - ".class".length());
        return classNameBase.replace(File.separatorChar, '.');
    }
}

